/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.examples;

import edu.iu.dsc.tws.tset.env.BatchTSetEnvironment;
import edu.iu.dsc.tws.tset.env.TSetEnvironment;
import edu.iu.dsc.tws.tset.worker.BatchTSetIWorker;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.runners.twister2.Twister2LegacyRunner;
import org.apache.beam.runners.twister2.Twister2PipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;

public class MinimalWordCount
implements Serializable,
BatchTSetIWorker {
    public void execute(BatchTSetEnvironment env) {
        System.out.println("Rank " + env.getWorkerID());
        Twister2PipelineOptions options = (Twister2PipelineOptions)PipelineOptionsFactory.as(Twister2PipelineOptions.class);
        options.setTSetEnvironment((TSetEnvironment)env);
        ((Twister2PipelineOptions)options.as(Twister2PipelineOptions.class)).setRunner(Twister2LegacyRunner.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.read().from("gs://apache-beam-samples/shakespeare/*"))).apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)word -> Arrays.asList(word.split("[^\\p{L}]+"))))).apply((PTransform)Filter.by((SerializableFunction & Serializable)word -> !word.isEmpty()))).apply(Count.perElement())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)wordCount -> (String)wordCount.getKey() + ": " + wordCount.getValue()))).apply((PTransform)TextIO.write().to("wordcounts"));
        p.run().waitUntilFinish();
    }
}

