/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.beam.runners.twister2.Twister2BatchTranslationContext;
import org.apache.beam.runners.twister2.Twister2PipelineOptions;
import org.apache.beam.runners.twister2.translators.BatchTransformTranslator;
import org.apache.beam.runners.twister2.translators.Twister2PipelineTranslator;
import org.apache.beam.runners.twister2.translators.batch.AssignWindowTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.FlattenTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.GroupByKeyTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.PCollectionViewTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.ParDoMultiOutputTranslatorBatch;
import org.apache.beam.runners.twister2.translators.batch.ReadSourceTranslatorBatch;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.Window;

public class Twister2BatchPipelineTranslator
extends Twister2PipelineTranslator {
    private static final Logger LOG = Logger.getLogger(Twister2BatchPipelineTranslator.class.getName());
    private final Twister2PipelineOptions options;
    private static final Map<Class<? extends PTransform>, BatchTransformTranslator> TRANSFORM_TRANSLATORS = new HashMap<Class<? extends PTransform>, BatchTransformTranslator>();
    private final Twister2BatchTranslationContext translationContext;

    public Twister2BatchPipelineTranslator(Twister2PipelineOptions options, Twister2BatchTranslationContext twister2TranslationContext) {
        this.options = options;
        this.translationContext = twister2TranslationContext;
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        LOG.fine(String.format("visiting transform %s", node.getTransform()));
        PTransform transform = node.getTransform();
        BatchTransformTranslator<?> translator = this.getTransformTranslator(transform.getClass());
        if (null == translator) {
            throw new IllegalStateException("no translator registered for " + transform);
        }
        this.translationContext.setCurrentTransform(node.toAppliedPTransform(this.getPipeline()));
        translator.translateNode(transform, this.translationContext);
    }

    private BatchTransformTranslator<?> getTransformTranslator(Class<? extends PTransform> transformClass) {
        return TRANSFORM_TRANSLATORS.get(transformClass);
    }

    private static <TT extends PTransform> void registerTransformTranslator(Class<TT> transformClass, BatchTransformTranslator<? extends TT> transformTranslator) {
        if (TRANSFORM_TRANSLATORS.put(transformClass, transformTranslator) != null) {
            throw new IllegalArgumentException("defining multiple translators for " + transformClass);
        }
    }

    static {
        Twister2BatchPipelineTranslator.registerTransformTranslator(Flatten.PCollections.class, new FlattenTranslatorBatch());
        Twister2BatchPipelineTranslator.registerTransformTranslator(Read.Bounded.class, new ReadSourceTranslatorBatch());
        Twister2BatchPipelineTranslator.registerTransformTranslator(ParDo.MultiOutput.class, new ParDoMultiOutputTranslatorBatch());
        Twister2BatchPipelineTranslator.registerTransformTranslator(Window.Assign.class, new AssignWindowTranslatorBatch());
        Twister2BatchPipelineTranslator.registerTransformTranslator(GroupByKey.class, new GroupByKeyTranslatorBatch());
        Twister2BatchPipelineTranslator.registerTransformTranslator(View.CreatePCollectionView.class, new PCollectionViewTranslatorBatch());
    }
}

