/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.utils;

import edu.iu.dsc.tws.api.dataset.DataPartition;
import edu.iu.dsc.tws.api.dataset.DataPartitionConsumer;
import edu.iu.dsc.tws.api.tset.TSetContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.Materializations;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class Twister2SideInputReader
implements SideInputReader {
    private static final Materializations.MultimapView EMPTY_MULTMAP_VIEW = o -> Collections.EMPTY_LIST;
    private final TSetContext runtimeContext;
    private final Map<TupleTag<?>, WindowingStrategy<?, ?>> sideInputs = new HashMap();

    public Twister2SideInputReader(Map<PCollectionView<?>, WindowingStrategy<?, ?>> indexByView, TSetContext context) {
        for (PCollectionView<?> pCollectionView : indexByView.keySet()) {
            Preconditions.checkArgument((boolean)Materializations.MULTIMAP_MATERIALIZATION_URN.equals(pCollectionView.getViewFn().getMaterialization().getUrn()), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", (Object)Materializations.MULTIMAP_MATERIALIZATION_URN, (Object)pCollectionView.getViewFn().getMaterialization().getUrn(), (Object)pCollectionView.getTagInternal().getId());
        }
        for (Map.Entry entry : indexByView.entrySet()) {
            this.sideInputs.put(((PCollectionView)entry.getKey()).getTagInternal(), (WindowingStrategy)entry.getValue());
        }
        this.runtimeContext = context;
    }

    @Nullable
    public <T> T get(PCollectionView<T> view, BoundedWindow window) {
        Preconditions.checkNotNull(view, (Object)"View passed to sideInput cannot be null");
        TupleTag tag = view.getTagInternal();
        Preconditions.checkNotNull(this.sideInputs.get(tag), (Object)("Side input for " + view + " not available."));
        return this.getSideInput(view, window);
    }

    public <T> boolean contains(PCollectionView<T> view) {
        return this.sideInputs.containsKey(view.getTagInternal());
    }

    public boolean isEmpty() {
        return false;
    }

    private <T> T getSideInput(PCollectionView<T> view, BoundedWindow window) {
        HashMap<BoundedWindow, List> partitionedElements = new HashMap<BoundedWindow, List>();
        DataPartition sideInput = this.runtimeContext.getInput(view.getTagInternal().getId());
        DataPartitionConsumer dataPartitionConsumer = sideInput.getConsumer();
        while (dataPartitionConsumer.hasNext()) {
            WindowedValue winValue = (WindowedValue)dataPartitionConsumer.next();
            for (BoundedWindow boundedWindow : winValue.getWindows()) {
                List windowedValues = partitionedElements.computeIfAbsent(boundedWindow, k -> new ArrayList());
                windowedValues.add(winValue);
            }
        }
        HashMap<BoundedWindow, Object> resultMap = new HashMap<BoundedWindow, Object>();
        for (Map.Entry entry : partitionedElements.entrySet()) {
            ViewFn viewFn = view.getViewFn();
            Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
            resultMap.put((BoundedWindow)entry.getKey(), viewFn.apply((Object)InMemoryMultimapSideInputView.fromIterable((Coder)keyCoder, (Iterable)((List)entry.getValue()).stream().map(WindowedValue::getValue).collect(Collectors.toList()))));
        }
        Object result = resultMap.get(window);
        if (result == null) {
            ViewFn viewFn = view.getViewFn();
            result = viewFn.apply((Object)EMPTY_MULTMAP_VIEW);
        }
        return (T)result;
    }
}

