/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2;

import edu.iu.dsc.tws.api.tset.sets.TSet;
import edu.iu.dsc.tws.api.tset.sets.batch.BatchTSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.beam.runners.twister2.Twister2BatchTranslationContext;
import org.apache.beam.runners.twister2.Twister2PipelineOptions;
import org.apache.beam.runners.twister2.Twister2StreamingTranslationContext;
import org.apache.beam.runners.twister2.Twister2TranslationContext;
import org.apache.beam.runners.twister2.translators.Twister2BatchPipelineTranslator;
import org.apache.beam.runners.twister2.translators.Twister2PipelineTranslator;
import org.apache.beam.runners.twister2.translators.Twister2StreamPipelineTranslator;
import org.apache.beam.sdk.Pipeline;

public class Twister2PiplineExecutionEnvironment {
    private static final Logger LOG = Logger.getLogger(Twister2PiplineExecutionEnvironment.class.getName());
    private final Twister2PipelineOptions options;
    private Twister2TranslationContext twister2TranslationContext;

    public Twister2PiplineExecutionEnvironment(Twister2PipelineOptions options) {
        this.options = options;
    }

    public void translate(Pipeline pipeline) {
        Twister2PipelineTranslator translator;
        boolean hasUnboundedOutput = false;
        if (this.options.isStreaming()) {
            this.twister2TranslationContext = new Twister2StreamingTranslationContext(this.options);
            translator = new Twister2StreamPipelineTranslator(this.options, this.twister2TranslationContext);
        } else {
            this.twister2TranslationContext = new Twister2BatchTranslationContext(this.options);
            translator = new Twister2BatchPipelineTranslator(this.options, (Twister2BatchTranslationContext)this.twister2TranslationContext);
        }
        translator.translate(pipeline);
    }

    public void execute() {
        this.twister2TranslationContext.execute();
    }

    public Map<String, BatchTSet<?>> getSideInputs() {
        return this.twister2TranslationContext.getSideInputDataSets();
    }

    public Set<TSet> getLeaves() {
        return this.twister2TranslationContext.getLeaves();
    }
}

