/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.examples;

import edu.iu.dsc.tws.api.JobConfig;
import edu.iu.dsc.tws.api.Twister2Job;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.rsched.core.ResourceAllocator;
import edu.iu.dsc.tws.rsched.job.Twister2Submitter;
import java.util.HashMap;
import org.apache.beam.runners.twister2.examples.WordCount;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class TestRunner {
    public static final String WORKERS = "workers";
    public static final String INPUT = "input";
    public static final String OUTPUT = "output";

    private TestRunner() {
    }

    public static void main(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption(WORKERS, true, "Workers");
        options.addOption(INPUT, true, "Input File");
        options.addOption(OUTPUT, true, "Output File");
        DefaultParser commandLineParser = new DefaultParser();
        CommandLine cmd = commandLineParser.parse(options, args);
        int workers = Integer.parseInt(cmd.getOptionValue(WORKERS));
        String input = cmd.getOptionValue(INPUT);
        String output = cmd.getOptionValue(OUTPUT);
        Config config = ResourceAllocator.loadConfig(new HashMap());
        JobConfig jobConfig = new JobConfig();
        jobConfig.put((Object)WORKERS, (Object)Integer.toString(workers));
        jobConfig.put((Object)INPUT, (Object)input);
        jobConfig.put((Object)OUTPUT, (Object)output);
        System.out.println("Start Beam Word Count example");
        Twister2Job.Twister2JobBuilder jobBuilder = Twister2Job.newBuilder();
        jobBuilder.setJobName("beam-test-job");
        jobBuilder.setWorkerClass(WordCount.class.getName());
        jobBuilder.addComputeResource(2.0, 512, 1.0, workers);
        jobBuilder.setConfig(jobConfig);
        Twister2Submitter.submitJob((Twister2Job)jobBuilder.build(), (Config)config);
    }
}

