/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.jpa.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.GeneratedValue;
import javax.persistence.LockModeType;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.util.ThreadContext;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.tynamo.security.jpa.EntitySecurityException;
import org.tynamo.security.jpa.annotations.Operation;
import org.tynamo.security.jpa.annotations.RequiresAssociation;
import org.tynamo.security.jpa.internal.RequiresAnnotationUtil;
import org.tynamo.security.services.SecurityService;

public class SecureEntityManager
implements EntityManager {
    private final EntityManager delegate;
    private final SecurityService securityService;
    private final HttpServletRequest request;
    private final PropertyAccess propertyAccess;
    private String realmName;
    private Class principalType;

    public SecureEntityManager(SecurityService securityService, PropertyAccess propertyAccess, HttpServletRequest request, EntityManager delegate, String realmName, Class principalType) {
        this.securityService = securityService;
        this.propertyAccess = propertyAccess;
        this.request = request;
        this.delegate = delegate;
        this.realmName = realmName;
        this.principalType = principalType;
    }

    public void clear() {
        this.delegate.clear();
    }

    public void close() {
        this.delegate.close();
    }

    public boolean contains(Object arg0) {
        return this.delegate.contains(arg0);
    }

    public <T> TypedQuery<T> createNamedQuery(String arg0, Class<T> arg1) {
        return this.delegate.createNamedQuery(arg0, arg1);
    }

    public Query createNamedQuery(String arg0) {
        return this.delegate.createNamedQuery(arg0);
    }

    public Query createNativeQuery(String arg0, Class arg1) {
        return this.delegate.createNativeQuery(arg0, arg1);
    }

    public Query createNativeQuery(String arg0, String arg1) {
        return this.delegate.createNativeQuery(arg0, arg1);
    }

    public Query createNativeQuery(String arg0) {
        return this.delegate.createNativeQuery(arg0);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> arg0) {
        return this.delegate.createQuery(arg0);
    }

    public <T> TypedQuery<T> createQuery(String arg0, Class<T> arg1) {
        return this.delegate.createQuery(arg0, arg1);
    }

    public Query createQuery(String arg0) {
        return this.delegate.createQuery(arg0);
    }

    public void detach(Object arg0) {
        this.delegate.detach(arg0);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)(ThreadContext.getSecurityManager() == null ? this.delegate.find(entityClass, primaryKey, lockMode, properties) : this.secureFind(entityClass, primaryKey, lockMode, properties));
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)(ThreadContext.getSecurityManager() == null ? this.delegate.find(entityClass, primaryKey, lockMode) : this.secureFind(entityClass, primaryKey, lockMode, null));
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)(ThreadContext.getSecurityManager() == null ? this.delegate.find(entityClass, primaryKey, properties) : this.secureFind(entityClass, primaryKey, null, properties));
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)(ThreadContext.getSecurityManager() == null ? this.delegate.find(entityClass, primaryKey) : this.secureFind(entityClass, primaryKey, null, null));
    }

    public void flush() {
        this.delegate.flush();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getCriteriaBuilder();
    }

    public Object getDelegate() {
        return this.delegate.getDelegate();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.delegate.getEntityManagerFactory();
    }

    public FlushModeType getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public LockModeType getLockMode(Object arg0) {
        return this.delegate.getLockMode(arg0);
    }

    public Metamodel getMetamodel() {
        return this.delegate.getMetamodel();
    }

    public Map<String, Object> getProperties() {
        return this.delegate.getProperties();
    }

    public <T> T getReference(Class<T> arg0, Object arg1) {
        return (T)this.delegate.getReference(arg0, arg1);
    }

    public EntityTransaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public void joinTransaction() {
        this.delegate.joinTransaction();
    }

    public void lock(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
        this.delegate.lock(arg0, arg1, arg2);
    }

    public void lock(Object arg0, LockModeType arg1) {
        this.delegate.lock(arg0, arg1);
    }

    public <T> T merge(T entity) {
        this.checkWritePermissions(entity, Operation.UPDATE);
        return (T)this.delegate.merge(entity);
    }

    public void persist(Object entity) {
        this.checkWritePermissions(entity, Operation.INSERT);
        this.delegate.persist(entity);
    }

    public void refresh(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
        this.delegate.refresh(arg0, arg1, arg2);
    }

    public void refresh(Object arg0, LockModeType arg1) {
        this.delegate.refresh(arg0, arg1);
    }

    public void refresh(Object arg0, Map<String, Object> arg1) {
        this.delegate.refresh(arg0, arg1);
    }

    public void refresh(Object arg0) {
        this.delegate.refresh(arg0);
    }

    public void remove(Object entity) {
        this.checkWritePermissions(entity, Operation.DELETE);
        this.delegate.remove(entity);
    }

    public void setFlushMode(FlushModeType arg0) {
        this.delegate.setFlushMode(arg0);
    }

    public void setProperty(String arg0, Object arg1) {
        this.delegate.setProperty(arg0, arg1);
    }

    public <T> T unwrap(Class<T> arg0) {
        return (T)this.delegate.unwrap(arg0);
    }

    private Object getConfiguredPrincipal() {
        if (!this.realmName.isEmpty()) {
            Collection principals = this.securityService.getSubject().getPrincipals().fromRealm(this.realmName);
            if (this.principalType == null) {
                principals.iterator().next();
            } else {
                for (Object availablePrincipal : principals) {
                    if (!availablePrincipal.getClass().isAssignableFrom(this.principalType)) continue;
                    return availablePrincipal;
                }
            }
        }
        if (this.principalType != null) {
            return this.securityService.getSubject().getPrincipals().oneByType(this.principalType);
        }
        return this.securityService.getSubject().getPrincipals().getPrimaryPrincipal();
    }

    private <T> T secureFind(Class<T> entityClass, Object entityId, LockModeType lockMode, Map<String, Object> properties) {
        SingularAttribute idAttr;
        Type idType;
        if (!this.securityService.getSubject().isAuthenticated()) {
            return null;
        }
        String requiredRoleValue = RequiresAnnotationUtil.getRequiredRole(entityClass, Operation.READ);
        if (requiredRoleValue != null && this.request.isUserInRole(requiredRoleValue)) {
            return (T)this.delegate.find(entityClass, entityId, lockMode, properties);
        }
        String requiredAssociationValue = RequiresAnnotationUtil.getRequiredAssociation(entityClass, Operation.READ);
        if (requiredAssociationValue == null) {
            if (requiredRoleValue != null) {
                return null;
            }
            if (entityId != null) {
                return (T)this.delegate.find(entityClass, entityId, lockMode, properties);
            }
            RequiresAssociation annotation = entityClass.getAnnotation(RequiresAssociation.class);
            if (annotation == null) {
                return null;
            }
            requiredAssociationValue = annotation.value();
        }
        CriteriaBuilder builder = this.delegate.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery();
        Root from = criteriaQuery.from(entityClass);
        CriteriaQuery select = criteriaQuery.select((Selection)from);
        Metamodel metamodel = this.delegate.getMetamodel();
        EntityType entityType = metamodel.entity(entityClass);
        Predicate predicate2 = null;
        Object principal = this.getConfiguredPrincipal();
        if (requiredAssociationValue.isEmpty()) {
            idType = entityType.getIdType();
            if (entityId == null) {
                entityId = principal;
            } else if (!entityId.equals(principal)) {
                return null;
            }
        } else {
            Attribute association = entityType.getAttribute(requiredAssociationValue);
            entityType = metamodel.entity(association.getJavaType());
            idType = entityType.getIdType();
            idAttr = entityType.getId(idType.getJavaType());
            Join join = from.join(requiredAssociationValue);
            predicate2 = builder.equal((Expression)join.get(idAttr.getName()), principal);
        }
        Predicate predicate1 = null;
        if (entityId != null) {
            idType = entityType.getIdType();
            idAttr = entityType.getId(idType.getJavaType());
            predicate1 = builder.equal((Expression)from.get(idAttr.getName()), entityId);
        }
        criteriaQuery.where(predicate1 == null ? predicate2 : (predicate2 == null ? predicate1 : builder.and(predicate1, predicate2)));
        List results = this.delegate.createQuery(criteriaQuery).getResultList();
        if (results.size() > 1) {
            throw new NonUniqueResultException("More than a single result of type " + entityClass.getName() + " found for " + (entityId == null ? "association " + requiredAssociationValue : "id " + entityId));
        }
        return results.size() <= 0 ? null : (T)results.get(0);
    }

    private Annotation getAnnotation(Member member, Class annotationType) {
        return member instanceof Field ? ((Field)member).getAnnotation(annotationType) : (member instanceof Method ? ((Method)member).getAnnotation(annotationType) : null);
    }

    public void checkWritePermissions(Object entity, Operation writeOperation) {
        Object associatedObject;
        if (ThreadContext.getSecurityManager() == null) {
            return;
        }
        String requiredRoleValue = RequiresAnnotationUtil.getRequiredRole(entity.getClass(), writeOperation);
        if (requiredRoleValue != null && this.request.isUserInRole(requiredRoleValue)) {
            return;
        }
        String requiredAssociationValue = RequiresAnnotationUtil.getRequiredAssociation(entity.getClass(), writeOperation);
        if (requiredAssociationValue == null) {
            if (requiredRoleValue == null) {
                return;
            }
            throw new EntitySecurityException("Currently executing subject is not permitted to " + (Object)((Object)writeOperation) + " entities of type " + entity.getClass().getSimpleName());
        }
        Metamodel metamodel = this.delegate.getMetamodel();
        EntityType entityType = metamodel.entity(entity.getClass());
        if (requiredAssociationValue.isEmpty()) {
            associatedObject = entity;
        } else {
            Attribute association = entityType.getAttribute(requiredAssociationValue);
            entityType = metamodel.entity(association.getJavaType());
            associatedObject = this.propertyAccess.get(entity, requiredAssociationValue);
            if (associatedObject == null) {
                throw new EntitySecurityException("Subject for the required association is not set when executing " + (Object)((Object)writeOperation) + " on instance '" + entity + "' of type " + entity.getClass().getSimpleName());
            }
        }
        Type idType = entityType.getIdType();
        SingularAttribute idAttr = entityType.getId(idType.getJavaType());
        if (associatedObject == entity && this.getAnnotation(idAttr.getJavaMember(), GeneratedValue.class) != null && Operation.INSERT.equals((Object)writeOperation) && this.propertyAccess.get(entity, idAttr.getName()) == null) {
            return;
        }
        Object principal = this.getConfiguredPrincipal();
        if (!this.propertyAccess.get(associatedObject, idAttr.getName()).equals(principal)) {
            throw new EntitySecurityException("Currently executing subject is not permitted to " + (Object)((Object)writeOperation) + " entities of type " + entity.getClass().getSimpleName() + " because the required association didn't exist");
        }
    }
}

