/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.jpa.internal;

import org.tynamo.security.jpa.annotations.Operation;
import org.tynamo.security.jpa.annotations.RequiresAssociation;
import org.tynamo.security.jpa.annotations.RequiresRole;

public abstract class RequiresAnnotationUtil {
    public static String getRequiredRole(Class<?> aClass, Operation operation) {
        RequiresRole annotation = aClass.getAnnotation(RequiresRole.class);
        if (annotation == null) {
            return null;
        }
        for (Operation requiredOperation : annotation.operations()) {
            if (Operation.ANY.equals((Object)requiredOperation) || operation.equals((Object)requiredOperation)) {
                return annotation.value();
            }
            if (!Operation.WRITE.equals((Object)requiredOperation) || !Operation.INSERT.equals((Object)operation) && !Operation.UPDATE.equals((Object)operation) && !Operation.DELETE.equals((Object)operation)) continue;
            return annotation.value();
        }
        return null;
    }

    public static String getRequiredAssociation(Class<?> aClass, Operation operation) {
        RequiresAssociation annotation = aClass.getAnnotation(RequiresAssociation.class);
        if (annotation == null) {
            return null;
        }
        for (Operation requiredOperation : annotation.operations()) {
            if (Operation.ANY.equals((Object)requiredOperation) || operation.equals((Object)requiredOperation)) {
                return annotation.value();
            }
            if (!Operation.WRITE.equals((Object)requiredOperation) || !Operation.INSERT.equals((Object)operation) && !Operation.UPDATE.equals((Object)operation) && !Operation.DELETE.equals((Object)operation)) continue;
            return annotation.value();
        }
        return null;
    }
}

