/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.base;

import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.hibernate.annotations.CommitAfter;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.tynamo.security.federatedaccounts.base.OauthComponentBase;
import org.tynamo.security.federatedaccounts.util.WindowMode;

public abstract class AbstractOauthPage
extends OauthComponentBase {
    private WindowMode windowMode;
    private String returnUri;
    private boolean oauthAuthenticated;
    @Environmental
    private JavaScriptSupport javaScriptSupport;

    public WindowMode getWindowMode() {
        return this.windowMode;
    }

    protected final Object onActivate(EventContext context) throws Exception {
        if (context.getCount() <= 0) {
            throw new IllegalArgumentException("Explicit windowMode is required but was not specified as a context argument");
        }
        this.windowMode = WindowMode.valueOf((String)context.get(String.class, 0));
        return this.isAutocommit() ? this.commitAfterOnActivate(context) : this.onOauthActivate(context);
    }

    @CommitAfter
    protected Object commitAfterOnActivate(EventContext context) throws Exception {
        return this.onOauthActivate(context);
    }

    protected abstract Object onOauthActivate(EventContext var1) throws Exception;

    public String getTitle() {
        return this.getProviderPrefix() + " account";
    }

    @Override
    protected Class getOauthPageClass() {
        return this.getClass();
    }

    public String getReturnUri() {
        return this.returnUri;
    }

    public void setReturnUri(String returnUri) {
        this.returnUri = returnUri;
    }

    public boolean isOauthAuthenticated() {
        return this.oauthAuthenticated;
    }

    public void setOauthAuthenticated(boolean oauthAuthenticated) {
        this.oauthAuthenticated = oauthAuthenticated;
    }

    protected void afterRender() {
        if (this.isOauthAuthenticated()) {
            this.javaScriptSupport.addScript("onAuthenticationSuccess('" + this.getReturnUri() + "', '" + this.getWindowMode().name() + "');", new Object[0]);
        }
    }
}

