/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.services;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.slf4j.Logger;
import org.tynamo.security.federatedaccounts.FederatedAccount;
import org.tynamo.security.federatedaccounts.services.AbstractFederatedAccountService;

public class DefaultJpaFederatedAccountServiceImpl
extends AbstractFederatedAccountService {
    private final EntityManager entityManager;

    public DefaultJpaFederatedAccountServiceImpl(Logger logger, @Symbol(value="federatedaccounts.localaccount_realmname") String localAccountRealmName, EntityManager entityManager, Map<String, Object> entityTypesByRealm) {
        super(logger, localAccountRealmName, entityTypesByRealm);
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    protected FederatedAccount findLocalAccount(Class<?> entityType, String realmName, Object remotePrincipal, Object remoteAccount) {
        if (!this.entityTypesByRealm.containsKey(realmName + ".id")) {
            this.logger.warn(String.format("Local account cannot be found. There's no property name configured for the federated realm attribute key %s.id and entity type %s", realmName + ".id", entityType.getSimpleName()));
            return null;
        }
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery();
        Root root = cq.from(entityType);
        cq.where((Expression)cb.equal((Expression)root.get((String)this.entityTypesByRealm.get(realmName + ".id")), remotePrincipal));
        TypedQuery query = this.entityManager.createQuery(cq.select((Selection)root));
        List results = query.getResultList();
        return results.size() <= 0 ? null : (FederatedAccount)results.get(0);
    }

    private EntityTransaction beginTransaction() {
        EntityTransaction transaction = this.entityManager.getTransaction();
        if (!transaction.isActive()) {
            transaction.begin();
        }
        return transaction;
    }

    @Override
    protected void saveAccount(FederatedAccount account) {
        EntityTransaction transaction = this.beginTransaction();
        this.entityManager.persist((Object)account);
        transaction.commit();
    }

    @Override
    protected void updateAccount(FederatedAccount account) {
        EntityTransaction transaction = this.beginTransaction();
        this.entityManager.merge((Object)account);
        transaction.commit();
    }
}

