/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.base;

import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;
import org.tynamo.security.federatedaccounts.FederatedAccount;
import org.tynamo.security.federatedaccounts.util.WindowMode;

public abstract class OauthComponentBase {
    private static final String CLIENTID = ".clientid";
    private static final String CLIENTSECRET = ".clientsecret";
    @Inject
    @Symbol(value="federatedaccounts.default_rememberme")
    private boolean rememberMe;
    @Inject
    protected Logger logger;
    @Inject
    private SymbolSource symbolSource;
    @Inject
    private PageRenderLinkSource linkSource;

    public String getProviderPrefix() {
        String name = this.getClass().getSimpleName();
        if (name.startsWith("OpenId")) {
            return FederatedAccount.FederatedAccountType.openid.name();
        }
        try {
            return FederatedAccount.FederatedAccountType.valueOf(name.substring(0, name.indexOf("Oauth")).toLowerCase()).name();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getOauthClientId() {
        return this.symbolSource.valueForSymbol(this.getProviderPrefix() + CLIENTID);
    }

    protected String getOauthClientSecret() {
        return this.symbolSource.valueForSymbol(this.getProviderPrefix() + CLIENTSECRET);
    }

    public boolean isOauthConfigured() {
        return !"".equals(this.getOauthClientId()) && !"".equals(this.getOauthClientSecret());
    }

    protected abstract Class getOauthPageClass();

    protected String getOauthRedirectLink(Object ... context) {
        if (context == null || !(context[0] instanceof WindowMode)) {
            throw new IllegalArgumentException("WindowMode is required as the first context parameter");
        }
        return this.linkSource.createPageRenderLinkWithContext(this.getOauthPageClass(), context).toAbsoluteURI();
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }
}

