/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.oauth.tokens;

import java.io.Serializable;
import java.util.Date;
import org.apache.shiro.authc.RememberMeAuthenticationToken;

public class OauthAccessToken
implements RememberMeAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private Serializable token;
    private Date expiration;
    private boolean rememberMe;

    public OauthAccessToken(Serializable accessToken, long expiresInSeconds) {
        this(accessToken, expiresInSeconds < 0L ? null : new Date(System.currentTimeMillis() + expiresInSeconds * 1000L));
    }

    public OauthAccessToken(Serializable accessToken, Date expiration) {
        this.token = accessToken;
        this.expiration = expiration;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public String toString() {
        return this.token.toString();
    }

    public Object getPrincipal() {
        return this.token;
    }

    public Object getCredentials() {
        return this.token;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }
}

