/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.services;

import java.util.Map;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.slf4j.Logger;
import org.tynamo.security.federatedaccounts.FederatedAccount;
import org.tynamo.security.federatedaccounts.services.FederatedAccountService;

public abstract class AbstractFederatedAccountService
implements FederatedAccountService {
    protected final Map<String, Object> entityTypesByRealm;
    protected final Class<?> singleEntityType;
    protected final Logger logger;
    protected final String localAccountRealmName;

    public AbstractFederatedAccountService(Logger logger, @Symbol(value="federatedaccounts.localaccount_realmname") String localAccountRealmName, Map<String, Object> entityTypesByRealm) {
        this.logger = logger;
        this.localAccountRealmName = localAccountRealmName;
        this.entityTypesByRealm = entityTypesByRealm;
        this.singleEntityType = entityTypesByRealm.containsKey("*") ? (Class)entityTypesByRealm.get("*") : null;
    }

    protected final Map<String, Object> getEntityTypesByRealm() {
        return this.entityTypesByRealm;
    }

    protected FederatedAccount createLocalAccount(Class<?> entityType, String realmName, Object remotePrincipal, Object remoteAccount) {
        FederatedAccount localAccount = null;
        try {
            localAccount = (FederatedAccount)entityType.newInstance();
        }
        catch (Exception e) {
            throw new AuthenticationException("Entity of type " + localAccount.getClass().getSimpleName() + " is not an instance of " + FederatedAccount.class.getSimpleName(), (Throwable)e);
        }
        localAccount.federate(realmName, remotePrincipal, remoteAccount);
        this.saveAccount(localAccount);
        return localAccount;
    }

    protected abstract void saveAccount(FederatedAccount var1);

    protected boolean updateLocalAccount(FederatedAccount localUser, String realmName, Object remotePrincipal, Object remoteAccount) {
        boolean modified = localUser.federate(realmName, null, remoteAccount);
        if (modified) {
            this.updateAccount(localUser);
        }
        return modified;
    }

    protected abstract void updateAccount(FederatedAccount var1);

    protected abstract FederatedAccount findLocalAccount(Class<?> var1, String var2, Object var3, Object var4);

    @Override
    public AuthenticationInfo federate(String realmName, Object remotePrincipal, AuthenticationToken authenticationToken, Object remoteAccount) {
        SimplePrincipalCollection principalCollection;
        Class entityType;
        Class clazz = entityType = this.singleEntityType == null ? (Class)this.entityTypesByRealm.get(realmName) : this.singleEntityType;
        if (entityType == null) {
            return null;
        }
        FederatedAccount localAccount = this.findLocalAccount(entityType, realmName, remotePrincipal, remoteAccount);
        if (localAccount == null) {
            localAccount = this.createLocalAccount(entityType, realmName, remotePrincipal, remoteAccount);
        } else {
            this.updateLocalAccount(localAccount, realmName, null, remoteAccount);
        }
        if (localAccount.isAccountLocked()) {
            throw new LockedAccountException("Federated account [" + remotePrincipal + "] is locked.");
        }
        if (localAccount.isCredentialsExpired()) {
            String msg = "The credentials for federated account [" + remotePrincipal + "] are expired";
            throw new ExpiredCredentialsException(msg);
        }
        if (this.localAccountRealmName.isEmpty()) {
            principalCollection = new SimplePrincipalCollection(remotePrincipal, realmName);
        } else {
            principalCollection = new SimplePrincipalCollection(localAccount.getLocalAccountPrimaryPrincipal(), this.localAccountRealmName);
            principalCollection.add(remotePrincipal, realmName);
        }
        principalCollection.add((Object)authenticationToken, realmName);
        return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, authenticationToken.getCredentials());
    }
}

