/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.services;

import java.util.Map;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.tynamo.security.federatedaccounts.FederatedAccount;
import org.tynamo.security.federatedaccounts.services.AbstractFederatedAccountService;
import org.tynamo.security.federatedaccounts.services.FederatedAccountService;

public class DefaultHibernateFederatedAccountServiceImpl
extends AbstractFederatedAccountService
implements FederatedAccountService {
    private final Session session;

    public DefaultHibernateFederatedAccountServiceImpl(Logger logger, @Symbol(value="federatedaccounts.localaccount_realmname") String localAccountRealmName, Session session, Map<String, Object> entityTypesByRealm) {
        super(logger, localAccountRealmName, entityTypesByRealm);
        this.session = session;
    }

    protected final Session getSession() {
        return this.session;
    }

    private Transaction beginTransaction() {
        Transaction transaction = this.session.beginTransaction();
        if (!transaction.isActive()) {
            transaction.begin();
        }
        return transaction;
    }

    @Override
    protected void saveAccount(FederatedAccount localAccount) {
        Transaction transaction = this.beginTransaction();
        this.session.save((Object)localAccount);
        transaction.commit();
    }

    @Override
    protected void updateAccount(FederatedAccount localUser) {
        Transaction transaction = this.beginTransaction();
        this.session.update((Object)localUser);
        transaction.commit();
    }

    @Override
    protected FederatedAccount findLocalAccount(Class<?> entityType, String realmName, Object remotePrincipal, Object remoteAccount) {
        if (!this.entityTypesByRealm.containsKey(realmName + ".id")) {
            this.logger.warn(String.format("Local account cannot be found. There's no property name configured for the federated realm attribute key %s.id and entity type %s", realmName + ".id", entityType.getSimpleName()));
            return null;
        }
        return (FederatedAccount)this.session.createCriteria(entityType).add((Criterion)Restrictions.eq((String)((String)this.entityTypesByRealm.get(realmName + ".id")), (Object)remotePrincipal)).uniqueResult();
    }
}

