// Generated by CoffeeScript 1.6.3
(function() {
  define(["jquery", "t5/core/dom"], function($, dom) {
    var PANEL_ANIMATION_DELAY, PANEL_ANIMATION_STEPS, PANEL_COLLAPSED_CLASS, PANEL_NORMAL_CLASS, animateContentPanel, animateStep;
    PANEL_ANIMATION_DELAY = 20;
    PANEL_ANIMATION_STEPS = 10;
    PANEL_NORMAL_CLASS = 'collapsiblepanel_content';
    PANEL_COLLAPSED_CLASS = 'collapsiblepanel_content collapsiblepanel_content_collapsed';
    animateContentPanel = function(panelContent, expanding) {
      var contentHeight, stepHeight;
      panelContent.style.display = "block";
      contentHeight = panelContent.offsetHeight;
      if (expanding) {
        panelContent.style.height = "0px";
      }
      stepHeight = contentHeight / PANEL_ANIMATION_STEPS;
      animateStep(panelContent, 1, stepHeight, expanding);
    };
    animateStep = function(panelContent, iteration, stepHeight, expanding) {
      if (iteration < PANEL_ANIMATION_STEPS) {
        panelContent.style.height = "" + (Math.round((expanding ? iteration : PANEL_ANIMATION_STEPS - iteration) * stepHeight)) + "px";
        iteration++;
        setTimeout((function() {
          return animateStep(panelContent, iteration, stepHeight, expanding);
        }), PANEL_ANIMATION_DELAY);
      } else {
        panelContent.className = expanding ? PANEL_NORMAL_CLASS : PANEL_COLLAPSED_CLASS;
        panelContent.style.display = panelContent.style.height = "";
      }
    };
    dom.onDocument("click", "span[data-action=collapsible]", function() {
      var contentElement, expanding;
      contentElement = this.element.parentNode.nextSibling;
      expanding = contentElement.className.indexOf('collapsed') > 0;
      this.element.className = expanding ? 'collapsiblepanel_header_title collapsiblepanel_header_title_expanded' : 'collapsiblepanel_header_title collapsiblepanel_header_title_collapsed';
      return animateContentPanel(contentElement, expanding);
    });
  });

}).call(this);

