/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.facebook.pages;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.BaseURLSource;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.esxx.js.protocol.GAEConnectionManager;
import org.slf4j.Logger;
import org.tynamo.security.federatedaccounts.base.AbstractOauthPage;
import org.tynamo.security.federatedaccounts.components.FlashMessager;
import org.tynamo.security.federatedaccounts.facebook.FacebookAccessToken;

public class FacebookOauth
extends AbstractOauthPage {
    @Inject
    @Symbol(value="httpclient.gae")
    private boolean httpClientOnGae;
    @Inject
    @Symbol(value="federatedaccounts.successurl")
    private String successUrl;
    @Inject
    private Logger logger;
    @Inject
    private Request request;
    @Component
    private FlashMessager flashMessager;
    @Inject
    private PageRenderLinkSource linkSource;
    private boolean oauthAuthenticated;
    @Inject
    private BaseURLSource baseURLSource;
    @Environmental
    private JavaScriptSupport javaScriptSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object onOauthActivate(EventContext eventContext) throws MalformedURLException {
        String code = this.request.getParameter("code");
        if (code == null) {
            this.flashMessager.setFailureMessage("No Oauth authentication code provided");
            return null;
        }
        ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
        qparams.add(new BasicNameValuePair("client_id", this.getOauthClientId()));
        qparams.add(new BasicNameValuePair("redirect_uri", this.getOauthRedirectLink(new Object[]{this.getWindowMode()})));
        qparams.add(new BasicNameValuePair("client_secret", this.getOauthClientSecret()));
        qparams.add(new BasicNameValuePair("code", code));
        HttpGet get = null;
        String accessToken = "";
        long expires = 0L;
        try {
            long len;
            URI uri = URIUtils.createURI((String)"https", (String)"graph.facebook.com", (int)-1, (String)"/oauth/access_token", (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null);
            get = new HttpGet(uri);
            DefaultHttpClient httpClient = this.httpClientOnGae ? new DefaultHttpClient((ClientConnectionManager)new GAEConnectionManager(), (HttpParams)new BasicHttpParams()) : new DefaultHttpClient();
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            int status = response.getStatusLine().getStatusCode();
            if (200 != status) {
                this.logger.error("Facebook access_token request returned status code " + status);
                this.flashMessager.setFailureMessage("Facebook access_token request failed with status code: " + status);
                Object var12_14 = null;
                return var12_14;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null && (len = entity.getContentLength()) != -1L && len < 2048L) {
                accessToken = EntityUtils.toString((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            this.logger.error("Facebook access_token request failed because of:", (Throwable)e);
            this.flashMessager.setFailureMessage("Facebook access_token request failed with message: " + e.getMessage());
            Object var9_11 = null;
            return var9_11;
        }
        finally {
            if (get != null) {
                get.abort();
            }
        }
        try {
            if (!accessToken.startsWith("access_token")) {
                throw new IllegalArgumentException();
            }
            accessToken = accessToken.substring(accessToken.indexOf("=") + 1);
            expires = Long.valueOf(accessToken.substring(accessToken.lastIndexOf("=") + 1));
            accessToken = accessToken.substring(0, accessToken.indexOf("&expires"));
        }
        catch (Exception e) {
            this.logger.error("access_token wasn't of right format");
            this.flashMessager.setFailureMessage("Facebook access_token wasn't of right format");
            return null;
        }
        try {
            SecurityUtils.getSubject().login((AuthenticationToken)new FacebookAccessToken(accessToken, expires));
            this.flashMessager.setSuccessMessage("User successfully authenticated");
            this.oauthAuthenticated = true;
        }
        catch (AuthenticationException e) {
            this.logger.error("Using access token " + accessToken + "\nCould not sign in a Facebook federated user because of: ", (Throwable)e);
            this.flashMessager.setFailureMessage("A Facebook federated user cannot be signed in, report this to support.\n " + e.getMessage());
            return null;
        }
        return null;
    }

    public String getSuccessLink() {
        return "".equals(this.successUrl) ? "" : this.baseURLSource.getBaseURL(this.request.isSecure()) + this.successUrl;
    }

    protected void afterRender() {
        if (this.oauthAuthenticated) {
            this.javaScriptSupport.addScript("onAuthenticationSuccess('" + this.getSuccessLink() + "', '" + this.getWindowMode().name() + "');", new Object[0]);
        }
    }
}

