/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.facebook.services;

import com.restfb.DefaultFacebookClient;
import com.restfb.Parameter;
import com.restfb.exception.FacebookException;
import com.restfb.types.User;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.slf4j.Logger;
import org.tynamo.security.federatedaccounts.FederatedAccount;
import org.tynamo.security.federatedaccounts.facebook.FacebookAccessToken;
import org.tynamo.security.federatedaccounts.services.FederatedAccountService;

public class FacebookRealm
extends AuthenticatingRealm {
    public static final String FACEBOOK_CLIENTID = "facebook.clientid";
    public static final String FACEBOOK_CLIENTSECRET = "facebook.clientsecret";
    public static final String FACEBOOK_PERMISSIONS = "facebook.permissions";
    public static final String FACEBOOK_PRINCIPAL = "facebook.principal";
    private Logger logger;
    private PrincipalProperty principalProperty;
    private FederatedAccountService federatedAccountService;

    public FacebookRealm(Logger logger, FederatedAccountService federatedAccountService, @Inject @Symbol(value="facebook.principal") String principalPropertyName) {
        super((CacheManager)new MemoryConstrainedCacheManager());
        this.federatedAccountService = federatedAccountService;
        this.logger = logger;
        this.principalProperty = PrincipalProperty.valueOf(principalPropertyName);
        this.setName(FederatedAccount.FederatedAccountType.facebook.name());
        this.setAuthenticationTokenClass(FacebookAccessToken.class);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        User facebookUser;
        FacebookAccessToken token = (FacebookAccessToken)authenticationToken;
        DefaultFacebookClient facebookClient = new DefaultFacebookClient(authenticationToken.getPrincipal().toString());
        try {
            facebookUser = (User)facebookClient.fetchObject("me", User.class, new Parameter[0]);
        }
        catch (FacebookException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new IncorrectCredentialsException("Facebook security verification failed, terminating authentication request", (Throwable)e);
        }
        if (facebookUser == null) {
            throw new AccountException("Null Facebook user is not allowed by this realm.");
        }
        String principalValue = null;
        switch (this.principalProperty) {
            case id: {
                principalValue = facebookUser.getId();
                break;
            }
            case email: {
                principalValue = facebookUser.getEmail();
                break;
            }
            case name: {
                principalValue = facebookUser.getName();
            }
        }
        AuthenticationInfo authenticationInfo = this.federatedAccountService.federate(FederatedAccount.FederatedAccountType.facebook.name(), (Object)principalValue, authenticationToken, (Object)facebookUser);
        return authenticationInfo;
    }

    public static enum PrincipalProperty {
        id,
        email,
        name;

    }
}

