/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.facebook.services;

import javax.servlet.Filter;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.services.LibraryMapping;
import org.tynamo.common.ModuleProperties;
import org.tynamo.security.federatedaccounts.facebook.pages.FacebookOauth;
import org.tynamo.security.federatedaccounts.facebook.services.FacebookRealm;
import org.tynamo.security.services.SecurityFilterChainFactory;
import org.tynamo.security.services.impl.SecurityFilterChain;

public class FacebookFederatedAccountsModule {
    private static final String PATH_PREFIX = "federated-facebook";
    private static String version = ModuleProperties.getVersion(FacebookFederatedAccountsModule.class);

    public static void bind(ServiceBinder binder) {
        binder.bind(AuthenticatingRealm.class, FacebookRealm.class).withId(FacebookRealm.class.getSimpleName());
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"facebook.principal", (Object)FacebookRealm.PrincipalProperty.id.name());
        configuration.add((Object)"facebook.permissions", (Object)"");
        configuration.add((Object)"facebook.clientid", (Object)"");
        configuration.add((Object)"facebook.clientsecret", (Object)"");
    }

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping("federated", "org.tynamo.security.federatedaccounts.facebook"));
    }

    public static void contributeClasspathAssetAliasManager(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)("federated-facebook-" + version), (Object)"org/tynamo/security/federatedaccounts/facebook");
    }

    public static void contributeWebSecurityManager(Configuration<Realm> configuration, @InjectService(value="FacebookRealm") AuthenticatingRealm facebookRealm) {
        configuration.add((Object)facebookRealm);
    }

    public static void contributeSecurityConfiguration(Configuration<SecurityFilterChain> configuration, SecurityFilterChainFactory factory) {
        configuration.add((Object)factory.createChain("/federated/" + FacebookOauth.class.getSimpleName().toLowerCase()).add((Filter)factory.anon()).build());
    }
}

