/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.facebook.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.tynamo.security.federatedaccounts.base.AbstractOauthSignIn;
import org.tynamo.security.federatedaccounts.facebook.pages.FacebookOauth;
import org.tynamo.security.federatedaccounts.util.WindowMode;

@Import(stylesheet={"fb-button.css"})
public class FacebookOauthSignIn
extends AbstractOauthSignIn {
    @Inject
    @Symbol(value="facebook.permissions")
    @Property
    private String facebookPermissions;
    @Parameter(defaultPrefix="literal")
    @Property
    private Integer width;
    @Parameter(defaultPrefix="literal")
    @Property
    private Integer height;
    @Parameter(defaultPrefix="literal", value="blank")
    private WindowMode windowMode;
    @Inject
    private AssetSource assetSource;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private PageRenderLinkSource pageRenderLinkSource;

    public boolean isWindowMode(String mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Window mode argument cannot be null");
        }
        return this.windowMode.equals((Object)WindowMode.valueOf((String)mode));
    }

    public String getOauthAuthorizationLink() {
        StringBuilder sb = new StringBuilder();
        sb.append("https://graph.facebook.com/oauth/authorize?client_id=");
        sb.append(this.getOauthClientId());
        sb.append("&redirect_uri=");
        sb.append(this.getOauthRedirectLink());
        sb.append("&display=popup");
        sb.append("&scope=");
        sb.append(this.facebookPermissions);
        return sb.toString();
    }

    public String getOauthRedirectLink() {
        if ("".equals(this.getReturnPageName())) {
            return this.getOauthRedirectLink(new Object[]{this.windowMode});
        }
        if ("^".equals(this.getReturnPageName())) {
            return this.getOauthRedirectLink(new Object[]{this.windowMode, this.pageRenderLinkSource.createPageRenderLink(this.componentResources.getPage().getClass()).toAbsoluteURI()});
        }
        return this.getOauthRedirectLink(new Object[]{this.windowMode, this.pageRenderLinkSource.createPageRenderLink(this.getReturnPageName()).toAbsoluteURI()});
    }

    protected Class<?> getOauthPageClass() {
        return FacebookOauth.class;
    }
}

