/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.facebook.pages;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;
import org.tynamo.security.federatedaccounts.base.AbstractOauthPage;
import org.tynamo.security.federatedaccounts.facebook.FacebookAccessToken;

public class FacebookOauth
extends AbstractOauthPage {
    @Inject
    private Logger logger;
    @Inject
    private Request request;
    @Inject
    private AlertManager alertManager;
    @Inject
    private PageRenderLinkSource linkSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object onOauthActivate(EventContext eventContext) throws MalformedURLException {
        DefaultHttpClient httpClient;
        String code = this.request.getParameter("code");
        if (eventContext.getCount() > 1) {
            this.setReturnUri((String)eventContext.get(String.class, 1));
        }
        if (code == null) {
            this.alertManager.error("No Oauth authentication code provided");
            return null;
        }
        ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
        qparams.add(new BasicNameValuePair("client_id", this.getOauthClientId()));
        qparams.add(new BasicNameValuePair("redirect_uri", this.getOauthRedirectLink(new Object[]{this.getWindowMode(), this.getReturnUri()})));
        qparams.add(new BasicNameValuePair("client_secret", this.getOauthClientSecret()));
        qparams.add(new BasicNameValuePair("code", code));
        HttpGet get = null;
        String accessToken = "";
        long expires = 0L;
        try {
            long len;
            URI uri = URIUtils.createURI((String)"https", (String)"graph.facebook.com", (int)-1, (String)"/oauth/access_token", (String)URLEncodedUtils.format(qparams, (String)"UTF-8"), null);
            get = new HttpGet(uri);
            httpClient = new DefaultHttpClient();
            HttpResponse response = httpClient.execute((HttpUriRequest)get);
            int status = response.getStatusLine().getStatusCode();
            if (200 != status) {
                this.logger.error("Facebook access_token request returned status code " + status);
                this.alertManager.error("Facebook access_token request failed with status code: " + status);
                Object var12_14 = null;
                return var12_14;
            }
            HttpEntity entity = response.getEntity();
            if (entity != null && (len = entity.getContentLength()) != -1L && len < 2048L) {
                accessToken = EntityUtils.toString((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            this.logger.error("Facebook access_token request failed because of:", (Throwable)e);
            this.alertManager.error("Facebook access_token request failed with message: " + e.getMessage());
            httpClient = null;
            return httpClient;
        }
        finally {
            if (get != null) {
                get.abort();
            }
        }
        try {
            if (!accessToken.startsWith("access_token")) {
                throw new IllegalArgumentException();
            }
            accessToken = accessToken.substring(accessToken.indexOf("=") + 1);
            expires = Long.valueOf(accessToken.substring(accessToken.lastIndexOf("=") + 1));
            accessToken = accessToken.substring(0, accessToken.indexOf("&expires"));
        }
        catch (Exception e) {
            this.logger.error("access_token wasn't of right format");
            this.alertManager.error("Facebook access_token wasn't of right format");
            return null;
        }
        FacebookAccessToken fbAccessToken = new FacebookAccessToken(accessToken, expires);
        fbAccessToken.setRememberMe(this.isRememberMe());
        try {
            SecurityUtils.getSubject().login((AuthenticationToken)fbAccessToken);
            this.alertManager.success("User successfully authenticated");
            this.setOauthAuthenticated(true);
        }
        catch (AuthenticationException e) {
            this.logger.error("Using access token " + accessToken + "\nCould not sign in a Facebook federated user because of: ", (Throwable)e);
            this.alertManager.error("A Facebook federated user cannot be signed in, report this to support.\n " + e.getMessage());
            return null;
        }
        return null;
    }
}

