/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.twitter.pages;

import java.net.URL;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.BaseURLSource;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.slf4j.Logger;
import org.tynamo.security.federatedaccounts.base.AbstractOauthPage;
import org.tynamo.security.federatedaccounts.components.FlashMessager;
import org.tynamo.security.federatedaccounts.twitter.TwitterAccessToken;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;

public class TwitterOauth
extends AbstractOauthPage {
    @Inject
    @Symbol(value="httpclient.gae")
    private boolean httpClientOnGae;
    @Inject
    @Symbol(value="federatedaccounts.successurl")
    private String successUrl;
    @Inject
    private Logger logger;
    @Inject
    private Request request;
    @Component
    private FlashMessager flashMessager;
    @Inject
    private PageRenderLinkSource linkSource;
    private boolean oauthAuthenticated;
    @Inject
    private TwitterFactory twitterFactory;
    @Inject
    private BaseURLSource baseURLSource;
    @Environmental
    private JavaScriptSupport javaScriptSupport;

    protected TwitterFactory getTwitterFactory() {
        return this.twitterFactory;
    }

    protected Object onOauthActivate(EventContext eventContext) throws Exception {
        String action;
        if (eventContext.getCount() > 1 && "request_token".equals(action = (String)eventContext.get(String.class, 1))) {
            Twitter twitter = this.getTwitterFactory().getInstance();
            twitter.setOAuthConsumer(this.getOauthClientId(), this.getOauthClientSecret());
            return new URL(twitter.getOAuthRequestToken(this.getOauthRedirectLink(new Object[]{this.getWindowMode()})).getAuthorizationURL());
        }
        String oauth_token = this.request.getParameter("oauth_token");
        String oauth_verifier = this.request.getParameter("oauth_verifier");
        if (oauth_verifier == null) {
            this.flashMessager.setFailureMessage("No Oauth verifier code provided");
            return null;
        }
        Twitter twitter = this.getTwitterFactory().getInstance();
        twitter.setOAuthConsumer(this.getOauthClientId(), this.getOauthClientSecret());
        AccessToken accessToken = twitter.getOAuthAccessToken(new RequestToken(oauth_token, this.getOauthClientSecret()), oauth_verifier);
        try {
            SecurityUtils.getSubject().login((AuthenticationToken)new TwitterAccessToken(accessToken));
            this.flashMessager.setSuccessMessage("User successfully authenticated");
            this.oauthAuthenticated = true;
        }
        catch (AuthenticationException e) {
            this.logger.error("Using access token " + accessToken + "\nCould not sign in a Twitter federated user because of: ", (Throwable)e);
            this.flashMessager.setFailureMessage("A Twitter federated user cannot be signed in, report this to support.\n " + e.getMessage());
        }
        return null;
    }

    public String getSuccessLink() {
        return "".equals(this.successUrl) ? "" : this.baseURLSource.getBaseURL(this.request.isSecure()) + this.successUrl;
    }

    protected void afterRender() {
        if (this.oauthAuthenticated) {
            this.javaScriptSupport.addScript("onAuthenticationSuccess('" + this.getSuccessLink() + "', '" + this.getWindowMode().name() + "');", new Object[0]);
        }
    }
}

