/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.twitter.services;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.slf4j.Logger;
import org.tynamo.security.federatedaccounts.FederatedAccount;
import org.tynamo.security.federatedaccounts.services.FederatedAccountService;
import org.tynamo.security.federatedaccounts.twitter.TwitterAccessToken;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.User;
import twitter4j.auth.AccessToken;

public class TwitterRealm
extends AuthenticatingRealm {
    public static final String TWITTER_CLIENTID = "twitter.clientid";
    public static final String TWITTER_CLIENTSECRET = "twitter.clientsecret";
    public static final String TWITTER_PRINCIPAL = "twitter.principal";
    private Logger logger;
    private PrincipalProperty principalProperty;
    private final FederatedAccountService federatedAccountService;
    private final TwitterFactory twitterFactory;
    private String oauthClientId;
    private String oauthClientSecret;

    public TwitterRealm(Logger logger, FederatedAccountService federatedAccountService, TwitterFactory twitterFactory, @Inject @Symbol(value="twitter.clientid") String oauthClientId, @Inject @Symbol(value="twitter.clientsecret") String oauthClientSecret, @Inject @Symbol(value="twitter.principal") String principalPropertyName) {
        super((CacheManager)new MemoryConstrainedCacheManager());
        this.federatedAccountService = federatedAccountService;
        this.twitterFactory = twitterFactory;
        this.oauthClientId = oauthClientId;
        this.oauthClientSecret = oauthClientSecret;
        this.logger = logger;
        this.principalProperty = PrincipalProperty.valueOf(principalPropertyName);
        this.setName(FederatedAccount.FederatedAccountType.twitter.name());
        this.setAuthenticationTokenClass(TwitterAccessToken.class);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        User twitterUser;
        AccessToken accessToken = (AccessToken)authenticationToken.getCredentials();
        Twitter twitter = this.twitterFactory.getInstance();
        twitter.setOAuthConsumer(this.oauthClientId, this.oauthClientSecret);
        twitter.setOAuthAccessToken(accessToken);
        try {
            twitterUser = twitter.verifyCredentials();
        }
        catch (TwitterException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new IncorrectCredentialsException("Twitter security verification failed, terminating authentication request", (Throwable)e);
        }
        String principalValue = null;
        switch (this.principalProperty) {
            case id: {
                principalValue = String.valueOf(twitterUser.getId());
                break;
            }
            case screenname: {
                principalValue = twitterUser.getScreenName();
                break;
            }
            case name: {
                principalValue = twitterUser.getName();
            }
        }
        AuthenticationInfo authenticationInfo = this.federatedAccountService.federate(FederatedAccount.FederatedAccountType.twitter.name(), (Object)principalValue, authenticationToken, (Object)twitterUser);
        return authenticationInfo;
    }

    public static enum PrincipalProperty {
        id,
        screenname,
        name;

    }
}

