/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.twitter.services;

import javax.servlet.Filter;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.services.LibraryMapping;
import org.tynamo.common.ModuleProperties;
import org.tynamo.security.federatedaccounts.services.FederatedAccountsModule;
import org.tynamo.security.federatedaccounts.twitter.pages.TwitterOauth;
import org.tynamo.security.federatedaccounts.twitter.services.TwitterRealm;
import org.tynamo.security.services.SecurityFilterChainFactory;
import org.tynamo.security.services.impl.SecurityFilterChain;
import twitter4j.TwitterFactory;

public class TwitterFederatedAccountsModule {
    private static final String PATH_PREFIX = "federated-twitter";
    private static String version = ModuleProperties.getVersion(FederatedAccountsModule.class);

    public static void bind(ServiceBinder binder) {
        binder.bind(AuthenticatingRealm.class, TwitterRealm.class).withId(TwitterRealm.class.getSimpleName());
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"twitter.principal", (Object)TwitterRealm.PrincipalProperty.id.name());
        configuration.add((Object)"twitter.clientid", (Object)"");
        configuration.add((Object)"twitter.clientsecret", (Object)"");
    }

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping("federated", "org.tynamo.security.federatedaccounts.twitter"));
    }

    public static void contributeClasspathAssetAliasManager(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)("federated-twitter-" + version), (Object)"org/tynamo/security/federatedaccounts/twitter");
    }

    public static void contributeWebSecurityManager(Configuration<Realm> configuration, @InjectService(value="TwitterRealm") AuthenticatingRealm twitterRealm) {
        configuration.add((Object)twitterRealm);
    }

    public static void contributeSecurityConfiguration(Configuration<SecurityFilterChain> configuration, SecurityFilterChainFactory factory) {
        configuration.add((Object)factory.createChain("/federated/" + TwitterOauth.class.getSimpleName().toLowerCase()).add((Filter)factory.anon()).build());
    }

    public static TwitterFactory build() {
        return new TwitterFactory();
    }
}

