/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.twitter.components;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.tynamo.security.federatedaccounts.base.AbstractOauthSignIn;
import org.tynamo.security.federatedaccounts.twitter.pages.TwitterOauth;
import org.tynamo.security.federatedaccounts.util.WindowMode;
import twitter4j.TwitterException;

public class TwitterOauthSignIn
extends AbstractOauthSignIn {
    @Parameter(defaultPrefix="literal", value="800")
    @Property
    private Integer width;
    @Parameter(defaultPrefix="literal", value="400")
    @Property
    private Integer height;
    @Parameter(value="darker", required=false, defaultPrefix="literal")
    private ButtonStyle buttonStyle;
    @Parameter(value="blank", required=false, defaultPrefix="literal")
    private WindowMode windowMode;
    @Inject
    private AssetSource assetSource;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private PageRenderLinkSource pageRenderLinkSource;
    @Inject
    private PageRenderLinkSource linkSource;

    public Asset getSignInImage() {
        return this.assetSource.getAsset(this.componentResources.getBaseResource(), this.buttonStyle.toString(), null);
    }

    public boolean isWindowMode(String mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Window mode argument cannot be null");
        }
        return this.windowMode.equals((Object)WindowMode.valueOf((String)mode));
    }

    protected Class<?> getOauthPageClass() {
        return TwitterOauth.class;
    }

    public String getOauthAuthorizationLink() throws TwitterException {
        return this.getOauthRedirectLink(new Object[]{this.windowMode, "request_token", this.getReturnPageUri()});
    }

    public static enum ButtonStyle {
        darker("sign-in-with-twitter-d.png"),
        darker_small("sign-in-with-twitter-d-sm.png"),
        lighter("sign-in-with-twitter-l.png"),
        ligter_small("sign-in-with-twitter-l-sm.png");

        private String resourceName;

        private ButtonStyle(String resourceName) {
            this.resourceName = resourceName;
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

