/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.services;

import java.util.Map;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.tynamo.security.federatedaccounts.FederatedAccount;
import org.tynamo.security.federatedaccounts.services.FederatedAccountService;

public class DefaultHibernateFederatedAccountServiceImpl
implements FederatedAccountService {
    private final Map<String, Object> entityTypesByRealm;
    private final Class<?> singleEntityType;
    private final Session session;

    public DefaultHibernateFederatedAccountServiceImpl(Session session, Map<String, Object> entityTypesByRealm) {
        this.entityTypesByRealm = entityTypesByRealm;
        this.singleEntityType = entityTypesByRealm.containsKey("*") ? (Class)entityTypesByRealm.get("*") : null;
        this.session = session;
    }

    protected final Session getSession() {
        return this.session;
    }

    protected final Map<String, Object> getEntityTypesByRealm() {
        return this.entityTypesByRealm;
    }

    protected FederatedAccount createLocalAccount(Class<?> entityType, String realmName, Object remotePrincipal, Object remoteAccount) {
        FederatedAccount localAccount = null;
        try {
            localAccount = (FederatedAccount)entityType.newInstance();
        }
        catch (Exception e) {
            throw new AuthenticationException("Entity of type " + localAccount.getClass().getSimpleName() + " is not an instance of " + FederatedAccount.class.getSimpleName(), (Throwable)e);
        }
        localAccount.federate(realmName, remotePrincipal, remoteAccount);
        this.session.save((Object)localAccount);
        return localAccount;
    }

    protected boolean updateLocalAccount(FederatedAccount localUser, String realmName, Object remotePrincipal, Object remoteAccount) {
        boolean modified = localUser.federate(realmName, null, remoteAccount);
        if (modified) {
            this.session.update((Object)localUser);
        }
        return modified;
    }

    FederatedAccount findLocalAccount(Class<?> entityType, String realmName, Object remotePrincipal, Object remoteAccount) {
        return (FederatedAccount)this.session.createCriteria(entityType).add((Criterion)Restrictions.eq((String)((String)this.entityTypesByRealm.get(realmName + ".id")), (Object)remotePrincipal)).uniqueResult();
    }

    @Override
    public AuthenticationInfo federate(String realmName, Object remotePrincipal, AuthenticationToken authenticationToken, Object remoteAccount) {
        Class entityType;
        Class clazz = entityType = this.singleEntityType == null ? (Class)this.entityTypesByRealm.get(realmName) : this.singleEntityType;
        if (entityType == null) {
            return null;
        }
        FederatedAccount localAccount = this.findLocalAccount(entityType, realmName, remotePrincipal, remoteAccount);
        if (localAccount == null) {
            localAccount = this.createLocalAccount(entityType, realmName, remotePrincipal, remoteAccount);
        } else {
            this.updateLocalAccount(localAccount, realmName, null, remoteAccount);
        }
        if (localAccount.isAccountLocked()) {
            throw new LockedAccountException("Federated account [" + remotePrincipal + "] is locked.");
        }
        if (localAccount.isCredentialsExpired()) {
            String msg = "The credentials for federated account [" + remotePrincipal + "] are expired";
            throw new ExpiredCredentialsException(msg);
        }
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection(remotePrincipal, realmName);
        principalCollection.add((Object)authenticationToken, realmName);
        return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, authenticationToken.getCredentials());
    }
}

