/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.security.federatedaccounts.services;

import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.apache.tapestry5.ioc.services.Coercion;
import org.apache.tapestry5.ioc.services.CoercionTuple;
import org.apache.tapestry5.services.LibraryMapping;
import org.tynamo.common.ModuleProperties;
import org.tynamo.security.FilterChainDefinition;
import org.tynamo.security.federatedaccounts.facebook.FacebookRealm;
import org.tynamo.security.federatedaccounts.pages.CommitFacebookOauth;
import org.tynamo.security.federatedaccounts.pages.FacebookOauth;
import org.tynamo.security.federatedaccounts.util.WindowMode;

public class FederatedAccountsModule {
    private static final String PATH_PREFIX = "federated";
    private static String version = ModuleProperties.getVersion(FederatedAccountsModule.class);

    public static void bind(ServiceBinder binder) {
        binder.bind(AuthenticatingRealm.class, FacebookRealm.class).withId(FacebookRealm.class.getSimpleName());
    }

    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"federatedaccounts.commitafteroauth", (Object)"true");
        configuration.add((Object)"httpclient.gae", (Object)"false");
        configuration.add((Object)"federatedaccounts.successurl", (Object)"");
        configuration.add((Object)"facebook.principal", (Object)FacebookRealm.PrincipalProperty.id.name());
        configuration.add((Object)"facebook.permissions", (Object)"");
        configuration.add((Object)"facebook.clientid", (Object)"");
        configuration.add((Object)"facebook.clientsecret", (Object)"");
    }

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration) {
        configuration.add((Object)new LibraryMapping(PATH_PREFIX, "org.tynamo.security.federatedaccounts"));
    }

    public static void contributeClasspathAssetAliasManager(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)("federated-" + version), (Object)"org/tynamo/security/federatedaccounts");
    }

    public static void contributeWebSecurityManager(Configuration<Realm> configuration, @InjectService(value="FacebookRealm") AuthenticatingRealm facebookRealm) {
        configuration.add((Object)facebookRealm);
    }

    public static void contributeSecurityRequestFilter(OrderedConfiguration<FilterChainDefinition> configuration) {
        configuration.add("facebookoauth", (Object)new FilterChainDefinition("/federated/" + FacebookOauth.class.getSimpleName().toLowerCase(), "anon"), new String[]{"before:*"});
        configuration.add("commitfacebookoauth", (Object)new FilterChainDefinition("/federated/" + CommitFacebookOauth.class.getSimpleName().toLowerCase(), "anon"), new String[]{"before:*"});
    }

    public void contributeTypeCoercer(Configuration<CoercionTuple<String, WindowMode>> configuration) {
        configuration.add((Object)new CoercionTuple(String.class, WindowMode.class, (Coercion)new Coercion<String, WindowMode>(){

            public WindowMode coerce(String input) {
                return WindowMode.valueOf(input);
            }
        }));
    }
}

