/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.conversations.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Request;
import org.tynamo.conversations.ConversationAware;
import org.tynamo.conversations.services.ConversationManager;

@IncludeJavaScriptLibrary(value={"ConversationModerator.js"})
public class ConversationModerator {
    private static final String eventName = "checkidle";
    @Inject
    private ComponentResources componentResources;
    @Environmental
    private RenderSupport renderSupport;
    @Parameter(value="15")
    private int idleCheck;
    @Parameter(value="30")
    private int warnBefore;
    @Parameter(defaultPrefix="literal")
    private String warnBeforeHandler;
    @Parameter(defaultPrefix="literal")
    private String endedHandler;
    @Parameter(value="false")
    private boolean keepAlive;
    @Inject
    private Request request;
    @Inject
    private ConversationManager conversationManager;

    JSONObject onCheckidle() {
        int nextCheckInSeconds = -1;
        JSONObject object = new JSONObject();
        String conversationId = this.conversationManager.getActiveConversation();
        if (conversationId != null) {
            int warnInSeconds;
            nextCheckInSeconds = this.conversationManager.getSecondsBeforeActiveConversationBecomesIdle();
            if (nextCheckInSeconds < 0) {
                return null;
            }
            if (this.componentResources.getContainer() instanceof ConversationAware) {
                ((ConversationAware)this.componentResources.getContainer()).onIdleCheck();
            }
            if ("true".equals(this.request.getParameter(ConversationManager.Parameters.keepalive.name()))) {
                --nextCheckInSeconds;
            }
            if ((warnInSeconds = Integer.valueOf(this.request.getParameter("warn")).intValue()) < 0) {
                ++nextCheckInSeconds;
            } else if ((warnInSeconds = nextCheckInSeconds - warnInSeconds) > 0) {
                nextCheckInSeconds = warnInSeconds;
            } else if (warnInSeconds > -nextCheckInSeconds) {
                object.put("warn", (Object)nextCheckInSeconds);
            }
        }
        object.put("nextCheck", (Object)nextCheckInSeconds);
        return object;
    }

    JSONObject onRefresh() {
        return null;
    }

    JSONObject onEnd() {
        this.conversationManager.endConversation(this.conversationManager.getActiveConversation());
        return new JSONObject();
    }

    @AfterRender
    public void afterRender() {
        Link link = this.componentResources.createEventLink(eventName, new Object[0]);
        String baseURI = link.toAbsoluteURI();
        int index = baseURI.indexOf(":checkidle");
        String defaultURIparameters = baseURI.substring(index + eventName.length() + 1);
        defaultURIparameters = defaultURIparameters + ("".equals(defaultURIparameters) ? "?" : "&");
        defaultURIparameters = defaultURIparameters + ConversationManager.Parameters.keepalive.name() + "=";
        baseURI = baseURI.substring(0, index + 1);
        this.renderSupport.addScript(String.format("%s = new ConversationModerator('%s', '%s', %s, true, %s, %s, '%s', '%s');", this.componentResources.getId(), baseURI, defaultURIparameters, this.keepAlive, this.idleCheck, this.warnBefore, this.warnBeforeHandler, this.endedHandler));
    }
}

