/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.conversations.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.Cookies;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Request;
import org.tynamo.conversations.services.Conversation;
import org.tynamo.conversations.services.ConversationManager;
import org.tynamo.conversations.services.ConversationalPersistentFieldStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationManagerImpl
implements ConversationManager {
    private final Request request;
    private final Cookies cookies;
    private ConversationalPersistentFieldStrategy pagePersistentFieldStrategy;

    public ConversationManagerImpl(Request request, Cookies cookies) {
        this.request = request;
        this.cookies = cookies;
    }

    protected Map<String, Conversation> getConversations() {
        Map conversations = (Map)this.request.getSession(true).getAttribute(Keys.conversations.toString());
        if (conversations == null) {
            conversations = Collections.synchronizedMap(new HashMap());
            this.request.getSession(true).setAttribute(Keys.conversations.toString(), conversations);
        }
        return conversations;
    }

    @Override
    public boolean activateConversation(Object parameterObject) {
        if (parameterObject == null) {
            return false;
        }
        EventContext activationContext = null;
        String pageName = null;
        if (parameterObject instanceof PageRenderRequestParameters) {
            activationContext = ((PageRenderRequestParameters)parameterObject).getActivationContext();
            pageName = ((PageRenderRequestParameters)parameterObject).getLogicalPageName();
        } else if (parameterObject instanceof ComponentEventRequestParameters) {
            activationContext = ((ComponentEventRequestParameters)parameterObject).getPageActivationContext();
            pageName = ((ComponentEventRequestParameters)parameterObject).getActivePageName();
        }
        String conversationId = null;
        try {
            conversationId = this.cookies.readCookieValue(pageName + (Object)((Object)Keys._conversationId));
            Conversation conversation = this.getConversations().get(conversationId);
            if (conversation == null) {
                conversationId = null;
            } else if (!conversation.isUsingCookie()) {
                conversationId = null;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (conversationId == null && activationContext != null) {
            try {
                conversationId = (String)activationContext.get(String.class, activationContext.getCount() - 1);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return this.activate(this.endConversationIfIdle(conversationId));
    }

    private boolean activate(Conversation conversation) {
        if (conversation == null) {
            return false;
        }
        this.request.setAttribute(Keys._conversationId.toString(), (Object)conversation.getId());
        return true;
    }

    @Override
    public String createConversation(String pageName, Integer maxIdleSeconds) {
        return this.createConversation(pageName, maxIdleSeconds, false);
    }

    @Override
    public String createConversation(String pageName, Integer maxIdleSeconds, boolean useCookie) {
        return this.createConversation(String.valueOf(System.currentTimeMillis()), pageName, maxIdleSeconds, 0, useCookie);
    }

    @Override
    public String createConversation(String pageName, Integer maxIdleSeconds, Integer maxConversationLengthSeconds, boolean useCookie) {
        return this.createConversation(String.valueOf(System.currentTimeMillis()), pageName, maxIdleSeconds, maxConversationLengthSeconds, useCookie);
    }

    @Override
    public String createConversation(String id, String pageName, Integer maxIdleSeconds, Integer maxConversationLengthSeconds, boolean useCookie) {
        String string = pageName = pageName == null ? "" : pageName.toLowerCase();
        if (useCookie) {
            this.cookies.writeCookieValue(pageName + Keys._conversationId.toString(), String.valueOf(id));
        }
        Conversation conversation = new Conversation(id, pageName, maxIdleSeconds, maxConversationLengthSeconds, useCookie);
        this.endIdleConversations();
        this.getConversations().put(id, conversation);
        this.activate(conversation);
        return id;
    }

    public void endIdleConversations() {
        Iterator<Conversation> iterator = this.getConversations().values().iterator();
        while (iterator.hasNext()) {
            Conversation conversation = iterator.next();
            if (!conversation.isIdle(false)) continue;
            this.discardConversation(conversation);
            iterator.remove();
        }
    }

    protected void discardConversation(Conversation conversation) {
        if (conversation == null) {
            return;
        }
        if (conversation.isUsingCookie()) {
            this.cookies.removeCookieValue(String.valueOf(conversation.getId()));
        }
        if (this.pagePersistentFieldStrategy != null) {
            this.pagePersistentFieldStrategy.discardChanges(conversation.getPageName());
        }
    }

    @Override
    public boolean exists(String conversationId) {
        Conversation conversation = this.getConversations().get(conversationId);
        return conversation != null;
    }

    protected Conversation endConversationIfIdle(String conversationId) {
        boolean resetTimeout;
        Conversation conversation = this.getConversations().get(conversationId);
        if (conversation == null) {
            return null;
        }
        boolean bl = resetTimeout = !"false".equals(this.request.getParameter(ConversationManager.Parameters.keepalive.name()));
        if (conversation.isIdle(resetTimeout)) {
            this.discardConversation(conversation);
            this.getConversations().remove(conversation.getId());
            conversationId = null;
        }
        return conversation;
    }

    @Override
    public String getActiveConversation() {
        String conversationId = (String)this.request.getAttribute(Keys._conversationId.toString());
        if (conversationId == null) {
            return null;
        }
        return this.exists(conversationId) ? conversationId : null;
    }

    @Override
    public int getSecondsBeforeActiveConversationBecomesIdle() {
        String conversationId = this.getActiveConversation();
        if (conversationId == null) {
            return -1;
        }
        Conversation conversation = this.getConversations().get(conversationId);
        if (conversation == null) {
            return -1;
        }
        return conversation.getSecondsBeforeBecomesIdle();
    }

    @Override
    public void setPagePersistentFieldStrategy(ConversationalPersistentFieldStrategy pagePersistentFieldStrategy) {
        this.pagePersistentFieldStrategy = pagePersistentFieldStrategy;
    }

    @Override
    public boolean isActiveConversation(String conversationId) {
        if (conversationId == null) {
            return false;
        }
        return conversationId.equals(this.getActiveConversation());
    }

    @Override
    public String endConversation(String conversationId) {
        Conversation conversation = this.getConversations().get(conversationId);
        if (conversation == null) {
            return null;
        }
        this.discardConversation(conversation);
        this.getConversations().remove(conversation.getId());
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Keys {
        _conversationId,
        conversations;

    }
}

