/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.conversations.services;

import java.io.Serializable;

public final class Conversation
implements Serializable {
    private static final long serialVersionUID = 333320784727498530L;
    private final String pageName;
    private final String sessionId;
    private final String id;
    private final boolean usingCookie;
    private final long maxIdleSeconds;
    private long lastTouched;
    private long requiredEndTimestamp;

    public boolean isUsingCookie() {
        return this.usingCookie;
    }

    public Conversation(String sessionId, String id, String pageName, Integer maxIdleSeconds, Integer maxConversationLengthSeconds, boolean usingCookie) {
        if (maxIdleSeconds == null) {
            maxIdleSeconds = 0;
        }
        if (maxConversationLengthSeconds == null) {
            maxConversationLengthSeconds = 0;
        }
        this.sessionId = sessionId;
        this.id = id;
        this.pageName = pageName;
        this.usingCookie = usingCookie;
        this.maxIdleSeconds = maxIdleSeconds.intValue();
        this.requiredEndTimestamp = maxConversationLengthSeconds == 0 ? 0L : System.currentTimeMillis() + (long)maxConversationLengthSeconds.intValue() * 1000L;
        this.touch();
    }

    public String getId() {
        return this.id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void touch() {
        this.lastTouched = System.currentTimeMillis();
    }

    public Integer getSecondsBeforeBecomesIdle() {
        if (this.maxIdleSeconds <= 0L) {
            return null;
        }
        int secondsLeft = (int)(this.maxIdleSeconds - (System.currentTimeMillis() - this.lastTouched) / 1000L);
        if (this.requiredEndTimestamp > 0L) {
            secondsLeft = Math.min(secondsLeft, (int)((this.requiredEndTimestamp - System.currentTimeMillis()) / 1000L));
        }
        return secondsLeft < 0 ? 0 : secondsLeft;
    }

    public boolean isIdle(boolean resetIdle) {
        if (this.requiredEndTimestamp > 0L && System.currentTimeMillis() > this.requiredEndTimestamp) {
            return true;
        }
        if (this.maxIdleSeconds < 1L) {
            if (resetIdle) {
                this.touch();
            }
            return false;
        }
        if ((System.currentTimeMillis() - this.lastTouched) / 1000L > this.maxIdleSeconds) {
            return true;
        }
        if (resetIdle) {
            this.touch();
        }
        return false;
    }
}

