/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.conversations.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.Cookies;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Request;
import org.tynamo.conversations.ConversationAware;
import org.tynamo.conversations.services.Conversation;
import org.tynamo.conversations.services.ConversationManager;
import org.tynamo.conversations.services.ConversationalPersistentFieldStrategy;

public class ConversationManagerImpl
implements ConversationManager {
    private final Request request;
    private final Cookies cookies;
    private ConversationalPersistentFieldStrategy pagePersistentFieldStrategy;
    private HttpServletRequest servletRequest;
    private Map<String, List<ConversationAware>> conversationAwareListeners = Collections.synchronizedMap(new HashMap());

    public ConversationManagerImpl(Request request, HttpServletRequest servletRequest, Cookies cookies, Map<Class, ConversationAware> listeners) {
        this.request = request;
        this.cookies = cookies;
        this.servletRequest = servletRequest;
        for (Map.Entry<Class, ConversationAware> entry : listeners.entrySet()) {
            String pageName = entry.getKey().getSimpleName();
            this.addConversationListener(pageName, entry.getValue());
        }
    }

    protected Map<String, Conversation> getConversations() {
        Map conversations = (Map)this.request.getSession(true).getAttribute(Keys.conversations.toString());
        if (conversations == null) {
            conversations = Collections.synchronizedMap(new HashMap());
            this.request.getSession(true).setAttribute(Keys.conversations.toString(), conversations);
        }
        return conversations;
    }

    @Override
    public boolean activateConversation(Object parameterObject) {
        if (parameterObject == null) {
            return false;
        }
        EventContext activationContext = null;
        String pageName = null;
        if (parameterObject instanceof PageRenderRequestParameters) {
            activationContext = ((PageRenderRequestParameters)parameterObject).getActivationContext();
            pageName = ((PageRenderRequestParameters)parameterObject).getLogicalPageName();
        } else if (parameterObject instanceof ComponentEventRequestParameters) {
            activationContext = ((ComponentEventRequestParameters)parameterObject).getPageActivationContext();
            pageName = ((ComponentEventRequestParameters)parameterObject).getActivePageName();
        }
        String conversationId = null;
        try {
            conversationId = this.cookies.readCookieValue(pageName.toLowerCase() + (Object)((Object)Keys._conversationId));
            Conversation conversation = this.getConversations().get(conversationId);
            if (conversation == null) {
                conversationId = null;
            } else if (!conversation.isUsingCookie()) {
                conversationId = null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (conversationId == null && activationContext != null) {
            try {
                conversationId = (String)activationContext.get(String.class, activationContext.getCount() - 1);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.activate(this.endConversationIfIdle(conversationId));
    }

    private boolean activate(Conversation conversation) {
        if (conversation == null) {
            return false;
        }
        this.request.setAttribute(Keys._conversationId.toString(), (Object)conversation.getId());
        return true;
    }

    @Override
    public String createConversation(String pageName, Integer maxIdleSeconds) {
        return this.createConversation(pageName, maxIdleSeconds, false);
    }

    @Override
    public String createConversation(String pageName, Integer maxIdleSeconds, boolean useCookie) {
        return this.createConversation(String.valueOf(System.currentTimeMillis()), pageName, maxIdleSeconds, 0, useCookie);
    }

    @Override
    public String createConversation(String pageName, Integer maxIdleSeconds, Integer maxConversationLengthSeconds, boolean useCookie) {
        return this.createConversation(String.valueOf(System.currentTimeMillis()), pageName, maxIdleSeconds, maxConversationLengthSeconds, useCookie);
    }

    @Override
    public String createConversation(String id, String pageName, Integer maxIdleSeconds, Integer maxConversationLengthSeconds, boolean useCookie) {
        String string = pageName = pageName == null ? "" : pageName;
        if (useCookie) {
            this.cookies.getBuilder(pageName.toLowerCase() + Keys._conversationId.toString(), String.valueOf(id)).write();
        }
        Conversation conversation = new Conversation(this.servletRequest.getSession(true).getId(), id, pageName, maxIdleSeconds, maxConversationLengthSeconds, useCookie);
        this.endIdleConversations();
        this.getConversations().put(id, conversation);
        this.activate(conversation);
        if (this.conversationAwareListeners.containsKey(conversation.getPageName())) {
            List<ConversationAware> conversationListeners = this.conversationAwareListeners.get(conversation.getPageName());
            for (ConversationAware conversationAware : conversationListeners) {
                conversationAware.onConversationCreated(conversation);
            }
        }
        return id;
    }

    public void endIdleConversations() {
        Iterator<Conversation> iterator = this.getConversations().values().iterator();
        while (iterator.hasNext()) {
            Conversation conversation = iterator.next();
            if (!conversation.isIdle(false)) continue;
            this.discardConversation(conversation, true);
            iterator.remove();
        }
    }

    protected void discardConversation(Conversation conversation, boolean expired) {
        if (conversation == null) {
            return;
        }
        if (this.conversationAwareListeners.containsKey(conversation.getPageName())) {
            List<ConversationAware> conversationListeners = this.conversationAwareListeners.get(conversation.getPageName());
            for (ConversationAware conversationAware : conversationListeners) {
                conversationAware.onConversationEnded(conversation, expired);
            }
        }
        if (conversation.isUsingCookie()) {
            this.cookies.removeCookieValue(String.valueOf(conversation.getId()));
        }
        if (this.pagePersistentFieldStrategy != null) {
            this.pagePersistentFieldStrategy.discardChanges(conversation.getPageName());
        }
    }

    @Override
    public boolean exists(String conversationId) {
        Conversation conversation = this.getConversations().get(conversationId);
        return conversation != null;
    }

    protected Conversation endConversationIfIdle(String conversationId) {
        boolean resetTimeout;
        Conversation conversation = this.getConversations().get(conversationId);
        if (conversation == null) {
            return null;
        }
        boolean bl = resetTimeout = !"false".equals(this.request.getParameter(ConversationManager.Parameters.keepalive.name()));
        if (conversation.isIdle(resetTimeout)) {
            this.discardConversation(conversation, true);
            this.getConversations().remove(conversation.getId());
            conversationId = null;
        }
        return conversation;
    }

    @Override
    public String getActiveConversation() {
        String conversationId = (String)this.request.getAttribute(Keys._conversationId.toString());
        if (conversationId == null) {
            return null;
        }
        return this.exists(conversationId) ? conversationId : null;
    }

    @Override
    public int getSecondsBeforeActiveConversationBecomesIdle() {
        String conversationId = this.getActiveConversation();
        if (conversationId == null) {
            return -1;
        }
        Conversation conversation = this.getConversations().get(conversationId);
        if (conversation == null) {
            return -1;
        }
        return conversation.getSecondsBeforeBecomesIdle();
    }

    @Override
    public void setPagePersistentFieldStrategy(ConversationalPersistentFieldStrategy pagePersistentFieldStrategy) {
        this.pagePersistentFieldStrategy = pagePersistentFieldStrategy;
    }

    @Override
    public boolean isActiveConversation(String conversationId) {
        if (conversationId == null) {
            return false;
        }
        return conversationId.equals(this.getActiveConversation());
    }

    @Override
    public String endConversation(String conversationId) {
        Conversation conversation = this.getConversations().get(conversationId);
        if (conversation == null) {
            return null;
        }
        this.discardConversation(conversation, false);
        this.getConversations().remove(conversation.getId());
        return null;
    }

    @Override
    public void addConversationListener(String pageName, ConversationAware conversationAware) {
        List<ConversationAware> conversationListenersForPage = this.conversationAwareListeners.get(pageName);
        if (conversationListenersForPage == null) {
            conversationListenersForPage = Collections.synchronizedList(new ArrayList());
            this.conversationAwareListeners.put(pageName, conversationListenersForPage);
        }
        conversationListenersForPage.add(conversationAware);
    }

    @Override
    public void removeConversationListener(String pageName, ConversationAware conversationAware) {
        List<ConversationAware> conversationListenersForPage = this.conversationAwareListeners.get(pageName);
        if (conversationListenersForPage == null) {
            return;
        }
        conversationListenersForPage.remove(conversationAware);
    }

    protected static enum Keys {
        _conversationId,
        conversations;

    }
}

