/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.conversations.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.internal.services.PersistentFieldChangeImpl;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.services.PersistentFieldChange;
import org.apache.tapestry5.services.PersistentFieldStrategy;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Session;
import org.tynamo.conversations.services.ConversationManager;

public class ConversationalPersistentFieldStrategy
implements PersistentFieldStrategy {
    static final String PREFIX = "state:";
    private final ConversationManager conversationManager;
    private final String prefix;
    private final Request request;

    public ConversationalPersistentFieldStrategy(Request request, ConversationManager conversationManager) {
        this.prefix = PREFIX;
        this.request = request;
        conversationManager.setPagePersistentFieldStrategy(this);
        this.conversationManager = conversationManager;
    }

    private String buildPrefix(String pageName) {
        return this.prefix + pageName + "_conversation_" + this.conversationManager.getActiveConversation() + ":";
    }

    public final Collection<PersistentFieldChange> gatherFieldChanges(String pageName) {
        Session session = this.request.getSession(false);
        if (session == null) {
            return Collections.emptyList();
        }
        List result = CollectionFactory.newList();
        if (this.conversationManager.getActiveConversation() == null) {
            return result;
        }
        String fullPrefix = this.buildPrefix(pageName);
        for (String name : session.getAttributeNames(fullPrefix)) {
            Object persistedValue = session.getAttribute(name);
            Object applicationValue = persistedValue == null ? null : this.convertPersistedToApplicationValue(persistedValue);
            PersistentFieldChange change = this.buildChange(name, applicationValue);
            result.add(change);
            this.didReadChange(session, name);
        }
        return result;
    }

    public void discardChanges(String pageName) {
        Session session = this.request.getSession(false);
        if (session == null || this.conversationManager.getActiveConversation() == null) {
            return;
        }
        String fullPrefix = this.buildPrefix(pageName);
        for (String name : session.getAttributeNames(fullPrefix)) {
            session.setAttribute(name, null);
        }
    }

    protected void didReadChange(Session session, String attributeName) {
    }

    private PersistentFieldChange buildChange(String name, Object newValue) {
        String[] chunks = name.split(":");
        String componentId = chunks[2];
        String fieldName = chunks[3];
        return new PersistentFieldChangeImpl(componentId, fieldName, newValue);
    }

    public static boolean isBlank(String input) {
        return input == null || input.length() == 0 || input.trim().length() == 0;
    }

    public final void postChange(String pageName, String componentId, String fieldName, Object newValue) {
        assert (!ConversationalPersistentFieldStrategy.isBlank(pageName));
        assert (!ConversationalPersistentFieldStrategy.isBlank(fieldName));
        if (this.conversationManager.getActiveConversation() == null) {
            return;
        }
        Object persistedValue = newValue == null ? null : this.convertApplicationValueToPersisted(newValue);
        StringBuilder builder = new StringBuilder(this.buildPrefix(pageName));
        if (componentId != null) {
            builder.append(componentId);
        }
        builder.append(':');
        builder.append(fieldName);
        Session session = this.request.getSession(persistedValue != null);
        if (session != null) {
            session.setAttribute(builder.toString(), persistedValue);
        }
    }

    protected Object convertApplicationValueToPersisted(Object newValue) {
        return newValue;
    }

    protected Object convertPersistedToApplicationValue(Object persistedValue) {
        return persistedValue;
    }
}

