/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.editablecontent.internal.services;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.tynamo.editablecontent.entities.RevisionedContent;
import org.tynamo.editablecontent.entities.TextualContent;
import org.tynamo.editablecontent.services.EditableContentStorage;

public class EditableContentStorageImpl
implements EditableContentStorage {
    private ThreadLocale threadLocale;
    private HttpServletRequest request;
    private ConcurrentMap<String, String> lruCache;
    private String persistenceUnitName;
    private EntityManagerManager entityManagerManager;

    public EditableContentStorageImpl(EntityManagerManager entityManagerManager, ThreadLocale threadLocale, HttpServletRequest request, @Inject @Symbol(value="editablecontent.localizedcontent") boolean localizedContent, @Inject @Symbol(value="editablecontent.persistenceunit") String persistenceUnitName, @Inject @Symbol(value="editablecontent.lrucachesize") int lruCacheSize) {
        EntityManager entityManager = null;
        if (persistenceUnitName.isEmpty()) {
            if (entityManagerManager.getEntityManagers().size() != 1) {
                throw new IllegalArgumentException("You have to specify the persistenceunit for editable content if multiple persistence units are configured in the system. Contribute a value for EditableContentSymbols.PERSISTENCEUNIT");
            }
            entityManager = (EntityManager)entityManagerManager.getEntityManagers().values().iterator().next();
        } else {
            entityManager = entityManagerManager.getEntityManager(persistenceUnitName);
            if (entityManager == null) {
                throw new IllegalArgumentException("Persistence unit '" + persistenceUnitName + "' is configured for editable content, but it was not found. Check that the contributed name matches with persistenceunit configuration");
            }
        }
        this.entityManagerManager = entityManagerManager;
        this.persistenceUnitName = persistenceUnitName;
        this.threadLocale = localizedContent ? threadLocale : null;
        this.request = request;
        this.lruCache = lruCacheSize <= 0 ? null : new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(lruCacheSize).build();
    }

    EntityManager getEntityManager() {
        return this.persistenceUnitName.isEmpty() ? (EntityManager)this.entityManagerManager.getEntityManagers().values().iterator().next() : this.entityManagerManager.getEntityManager(this.persistenceUnitName);
    }

    private String localizeContentId(String contentId) {
        if (this.threadLocale == null || this.threadLocale.getLocale() == null) {
            return contentId;
        }
        return contentId + "_" + this.threadLocale.getLocale().toString();
    }

    @Override
    public boolean contains(String contentId) {
        EntityManager entityManager = this.getEntityManager();
        contentId = this.localizeContentId(contentId);
        CriteriaBuilder qb = entityManager.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Long.class);
        Root from = cq.from(TextualContent.class);
        cq.select((Selection)qb.count((Expression)from));
        cq.where((Expression)qb.equal((Expression)from.get("id"), (Object)contentId));
        return (Long)entityManager.createQuery(cq).getSingleResult() > 0L;
    }

    void createRevision(TextualContent content, int maxHistory) {
        EntityManager entityManager = this.getEntityManager();
        RevisionedContent revision = new RevisionedContent(content);
        entityManager.persist((Object)revision);
        if (maxHistory > 0) {
            CriteriaBuilder builder = entityManager.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(RevisionedContent.class);
            Root from = query.from(RevisionedContent.class);
            query.where((Expression)builder.equal((Expression)from.get("id"), (Object)content.getId()));
            query.orderBy(new Order[]{builder.desc((Expression)from.get("revision"))});
            List revisions = entityManager.createQuery(query).getResultList();
            int size = revisions.size();
            int i = 0;
            while (size - i > maxHistory) {
                entityManager.remove(revisions.get(i));
                ++i;
            }
        }
    }

    @Override
    public String updateContent(String contentId, String contentValue, int maxHistory) {
        EntityManager entityManager = this.getEntityManager();
        TextualContent content = (TextualContent)entityManager.find(TextualContent.class, (Object)(contentId = this.localizeContentId(contentId)));
        if (content == null) {
            content = new TextualContent();
            content.setId(contentId);
        } else if (maxHistory >= 0) {
            this.createRevision(content, maxHistory);
        }
        content.setValue(contentValue);
        content.setLastModified(new Date());
        String author = this.request.getRemoteUser();
        if (author == null) {
            author = this.request.getRemoteAddr();
        }
        content.setAuthor(author);
        entityManager.persist((Object)content);
        if (this.lruCache != null) {
            this.lruCache.remove(contentId);
        }
        return null;
    }

    @Override
    public String getTextualContentValue(String contentId) {
        String value;
        EntityManager entityManager = this.getEntityManager();
        contentId = this.localizeContentId(contentId);
        String string = value = this.lruCache == null ? null : (String)this.lruCache.get(contentId);
        if (value == null) {
            TextualContent content = (TextualContent)entityManager.find(TextualContent.class, (Object)contentId);
            value = content.getValue();
            this.lruCache.put(contentId, value);
        }
        return value;
    }

    @Override
    public TextualContent getTextualContent(String contentId) {
        return (TextualContent)this.getEntityManager().find(TextualContent.class, (Object)this.localizeContentId(contentId));
    }
}

