/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.editablecontent.components;

import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationDecorator;
import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.annotations.AfterRenderBody;
import org.apache.tapestry5.annotations.BeforeRenderBody;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.PageReset;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.internal.DefaultValidationDecorator;
import org.apache.tapestry5.internal.services.MarkupWriterImpl;
import org.apache.tapestry5.internal.services.RenderQueueImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;
import org.tynamo.editablecontent.entities.TextualContent;
import org.tynamo.editablecontent.services.EditableContentStorage;

@Import(stylesheet={"EditableContent.css"})
public class EditableContent {
    @Inject
    @Symbol(value="editablecontent.readonlybydefault")
    private boolean defaultReadOnly;
    @Parameter(value="defaultReadOnly")
    private boolean readOnly;
    @Inject
    @Symbol(value="editablecontent.defaultauthorrole")
    private String defaultAuthorRole;
    @Parameter(value="defaultAuthorRole")
    private String authorRole;
    @Parameter(value="defaultContentId")
    private String contentId;
    @Parameter(defaultPrefix="literal", value="100")
    private int maxHistory;
    @Property
    private String contentValue;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private Request request;
    @Inject
    private EditableContentStorage contentStorage;
    @Persist(value="client")
    private Long versionForEdit;
    @Persist(value="session")
    private boolean inEditMode;
    @Inject
    private HttpServletRequest httpServletRequest;
    @InjectComponent
    Zone contentZone;
    @Inject
    private AlertManager alertManager;
    @InjectComponent
    private Form contentEditorForm;
    @Inject
    private Environment environment;
    @Inject
    private AssetSource assetSource;
    @Inject
    private Logger logger;

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public String getDefaultAuthorRole() {
        return this.defaultAuthorRole;
    }

    public String getDefaultContentId() {
        return this.componentResources.getId();
    }

    @BeforeRenderBody
    public Object dontRenderContent(MarkupWriter writer) {
        return false;
    }

    @PageReset
    public void resetToReadMode() {
        this.componentResources.discardPersistentFieldChanges();
    }

    @AfterRenderBody
    public Object renderContent(MarkupWriter writer) {
        TextualContent content = this.contentStorage.getTextualContent(this.contentId);
        if (content == null) {
            return this.componentResources.getBody();
        }
        writer.writeRaw(content.getValue());
        return true;
    }

    public boolean isEdited() {
        if (this.request.getSession(false) == null) {
            return false;
        }
        return this.inEditMode;
    }

    public boolean isEditable() {
        if (this.readOnly) {
            return false;
        }
        return this.httpServletRequest.isUserInRole(this.authorRole);
    }

    public Object onActionFromCancelLink() {
        this.inEditMode = false;
        return this.request.isXHR() ? this.contentZone.getBody() : null;
    }

    public Object onActionFromEditLink() {
        this.inEditMode = true;
        TextualContent content = this.contentStorage.getTextualContent(this.contentId);
        if (content == null) {
            this.versionForEdit = null;
            this.contentValue = this.renderMarkup((RenderCommand)this.componentResources.getBody());
            if (this.contentValue == null) {
                this.contentValue = "";
            }
        } else {
            this.versionForEdit = content.getVersion();
            this.contentValue = content.getValue();
        }
        return this.request.isXHR() ? this.contentZone.getBody() : null;
    }

    public void onValidateFromContentEditorForm() {
        this.inEditMode = false;
        if (!this.httpServletRequest.isUserInRole(this.authorRole)) {
            this.contentEditorForm.recordError("Changes ignored, you are not authorized to modify this content");
            return;
        }
        if (this.versionForEdit != null) {
            TextualContent content = this.contentStorage.getTextualContent(this.contentId);
            if (this.versionForEdit.longValue() != content.getVersion()) {
                this.alertManager.warn(content.getAuthor() + " had modified contents after you started editing, those changes were erased!");
            }
        }
        this.contentStorage.updateContent(this.contentId, this.contentValue, this.maxHistory);
    }

    Object onSuccess() {
        TextualContent content = this.contentStorage.getTextualContent(this.contentId);
        this.versionForEdit = content.getVersion();
        return this.request.isXHR() ? this.contentZone.getBody() : null;
    }

    Object onFailure() {
        return this.request.isXHR() ? this.contentZone.getBody() : null;
    }

    private String renderMarkup(RenderCommand renderCommand) {
        MarkupWriterImpl markupWriter = new MarkupWriterImpl();
        DefaultValidationDecorator decorator = new DefaultValidationDecorator(this.environment, this.assetSource.getExpandedAsset("${tapestry.spacer-image}"), (MarkupWriter)markupWriter);
        this.environment.push(ValidationDecorator.class, (Object)decorator);
        RenderQueueImpl renderQueue = new RenderQueueImpl(this.logger);
        renderQueue.push(renderCommand);
        renderQueue.run((MarkupWriter)markupWriter);
        this.environment.pop(ValidationDecorator.class);
        return markupWriter.toString().replaceAll("^\\n+", "").replaceAll("\\n+$", "");
    }
}

