/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.editablecontent.entities;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.tynamo.editablecontent.entities.TextualContent;

@Entity
@IdClass(value=RevisionedContentId.class)
public class RevisionedContent {
    public static final int CONTENT_MAX_LENGTH = 10000;
    @Id
    @Column(length=255)
    private String id;
    @Id
    private long revision;
    @Column(length=255)
    private String author;
    @Lob
    @Column(length=10000)
    private byte[] value;
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    @Column(nullable=false, updatable=false)
    private Date lastModified = new Date();

    public RevisionedContent() {
    }

    public RevisionedContent(TextualContent textualContent) {
        this.id = textualContent.getId();
        this.revision = textualContent.getVersion();
        this.author = textualContent.getAuthor();
        this.lastModified = textualContent.getLastModified();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(textualContent.getValue().getBytes(Charset.forName("UTF-8")));
            gzip.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.value = out.toByteArray();
    }

    public String valueToString() {
        try {
            String line;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.value);
            GZIPInputStream gzis = new GZIPInputStream(bais);
            InputStreamReader reader = new InputStreamReader((InputStream)gzis, Charset.forName("UTF-8"));
            BufferedReader in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getAuthor() {
        return this.author;
    }

    public long getRevision() {
        return this.revision;
    }

    public static class RevisionedContentId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private long revision;

        public RevisionedContentId() {
        }

        public RevisionedContentId(String id, long revision) {
            this.id = id;
            this.revision = revision;
        }

        public String getId() {
            return this.id;
        }

        public long getRevision() {
            return this.revision;
        }

        public boolean equals(Object o) {
            return o instanceof RevisionedContentId && this.id == ((RevisionedContentId)o).getId() && this.revision == ((RevisionedContentId)o).getRevision();
        }

        public int hashCode() {
            return (this.id + this.revision).hashCode();
        }
    }
}

