/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.exceptionpage.services;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.services.LinkSource;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.runtime.ComponentEventException;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestExceptionHandler;
import org.apache.tapestry5.services.Response;
import org.tynamo.exceptionpage.ContextAwareException;
import org.tynamo.exceptionpage.ExceptionHandlerAssistant;
import org.tynamo.exceptionpage.services.ExceptionHandler;

public class ConfigurableRequestExceptionHandler
implements RequestExceptionHandler {
    private final ExceptionHandler exceptionHandler;
    private final RequestExceptionHandler defaultRequestExceptionHandler;
    private final LinkSource linkSource;
    private final Response response;
    private final ComponentClassResolver componentClassResolver;
    private final Request request;
    private final Map<Class<ExceptionHandlerAssistant>, ExceptionHandlerAssistant> handlerAssistants = Collections.synchronizedMap(new HashMap());
    private final ServiceResources serviceResources;

    public ConfigurableRequestExceptionHandler(RequestExceptionHandler requestExceptionHandler, ServiceResources serviceResources, ComponentClassResolver componentClassResolver, LinkSource linkSource, Request request, Response response, ExceptionHandler exceptionHandler) {
        this.defaultRequestExceptionHandler = requestExceptionHandler;
        this.serviceResources = serviceResources;
        this.componentClassResolver = componentClassResolver;
        this.linkSource = linkSource;
        this.request = request;
        this.response = response;
        this.exceptionHandler = exceptionHandler;
    }

    protected Object[] formExceptionContext(Throwable exception) {
        if (exception instanceof ContextAwareException) {
            return ((ContextAwareException)((Object)exception)).getContext();
        }
        if (exception.getMessage() == null) {
            return new Object[0];
        }
        return new Object[]{exception.getMessage()};
    }

    public void handleRequestException(Throwable exception) throws IOException {
        Throwable cause = exception;
        while (cause instanceof ComponentEventException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        Class<?> causeClass = cause.getClass();
        if (!(this.exceptionHandler.getConfiguration().containsKey(causeClass) || (causeClass = causeClass.getSuperclass()) != null && this.exceptionHandler.getConfiguration().containsKey(causeClass))) {
            this.defaultRequestExceptionHandler.handleRequestException(exception);
            return;
        }
        Class pageClass = this.exceptionHandler.getConfiguration().get(cause.getClass());
        Object[] exceptionContext = this.formExceptionContext(cause);
        if (ExceptionHandlerAssistant.class.isAssignableFrom(pageClass)) {
            Class handlerType = pageClass;
            ExceptionHandlerAssistant assistant = this.handlerAssistants.get(handlerType);
            if (assistant == null) {
                assistant = (ExceptionHandlerAssistant)this.serviceResources.autobuild(handlerType);
                this.handlerAssistants.put(handlerType, assistant);
            }
            if ((pageClass = assistant.handleRequestException(exception, Arrays.asList(exceptionContext))) == null) {
                return;
            }
        }
        Link link = this.linkSource.createPageRenderLink(this.componentClassResolver.resolvePageClassNameToPageName(pageClass.getName()), false, exceptionContext);
        try {
            if (this.request.isXHR()) {
                OutputStream os = this.response.getOutputStream("application/json;charset=UTF-8");
                os.write(("{\"script\":\"window.location.replace('" + link.toAbsoluteURI() + "');\"}").getBytes());
                os.close();
            } else {
                this.response.sendRedirect(link);
            }
        }
        catch (Exception e) {
            this.defaultRequestExceptionHandler.handleRequestException(exception);
        }
    }
}

