/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.exceptionpage.services;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.services.LinkSource;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.internal.OperationException;
import org.apache.tapestry5.runtime.ComponentEventException;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestExceptionHandler;
import org.apache.tapestry5.services.Response;
import org.tynamo.exceptionpage.ContextAwareException;
import org.tynamo.exceptionpage.ExceptionHandlerAssistant;
import org.tynamo.exceptionpage.services.ExceptionHandler;

public class ConfigurableRequestExceptionHandler
implements RequestExceptionHandler {
    private final ExceptionHandler exceptionHandler;
    private final RequestExceptionHandler defaultRequestExceptionHandler;
    private final LinkSource linkSource;
    private final Response response;
    private final ComponentClassResolver componentClassResolver;
    private final Request request;
    private final Map<Class<ExceptionHandlerAssistant>, ExceptionHandlerAssistant> handlerAssistants = Collections.synchronizedMap(new HashMap());
    private final ServiceResources serviceResources;

    public ConfigurableRequestExceptionHandler(RequestExceptionHandler requestExceptionHandler, ServiceResources serviceResources, ComponentClassResolver componentClassResolver, LinkSource linkSource, Request request, Response response, ExceptionHandler exceptionHandler) {
        this.defaultRequestExceptionHandler = requestExceptionHandler;
        this.serviceResources = serviceResources;
        this.componentClassResolver = componentClassResolver;
        this.linkSource = linkSource;
        this.request = request;
        this.response = response;
        this.exceptionHandler = exceptionHandler;
    }

    protected Object[] formExceptionContext(Throwable exception) {
        if (exception instanceof ContextAwareException) {
            return ((ContextAwareException)((Object)exception)).getContext();
        }
        Class<RuntimeException> exceptionClass = exception.getClass();
        while ("".equals(exceptionClass.getSimpleName())) {
            exceptionClass = exceptionClass.getSuperclass();
        }
        if (exceptionClass.isAssignableFrom(RuntimeException.class)) {
            Object[] objectArray;
            if (exception.getMessage() == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = exception.getMessage().toLowerCase();
            }
            return objectArray;
        }
        String exceptionType = exceptionClass.getSimpleName();
        if (exceptionType.endsWith("Exception")) {
            exceptionType = exceptionType.substring(0, exceptionType.length() - 9);
        }
        return new Object[]{exceptionType.toLowerCase()};
    }

    public void handleRequestException(Throwable exception) throws IOException {
        Throwable cause = exception;
        while ((cause instanceof OperationException || cause instanceof ComponentEventException) && cause.getCause() != null) {
            cause = cause.getCause();
        }
        Class<?> causeClass = cause.getClass();
        if (!(this.exceptionHandler.getConfiguration().containsKey(causeClass) || (causeClass = causeClass.getSuperclass()) != null && this.exceptionHandler.getConfiguration().containsKey(causeClass) || (causeClass = causeClass.getSuperclass()) != null && this.exceptionHandler.getConfiguration().containsKey(causeClass))) {
            this.defaultRequestExceptionHandler.handleRequestException(exception);
            return;
        }
        Object[] exceptionContext = this.formExceptionContext(cause);
        Object value = this.exceptionHandler.getConfiguration().get(causeClass);
        Object page = null;
        ExceptionHandlerAssistant assistant = null;
        if (value instanceof ExceptionHandlerAssistant) {
            assistant = (ExceptionHandlerAssistant)value;
        } else {
            Class handlerType;
            if (!(value instanceof Class)) {
                this.defaultRequestExceptionHandler.handleRequestException(exception);
                return;
            }
            if (ExceptionHandlerAssistant.class.isAssignableFrom((Class)value) && (assistant = this.handlerAssistants.get(handlerType = (Class)value)) == null) {
                assistant = (ExceptionHandlerAssistant)this.serviceResources.autobuild(handlerType);
                this.handlerAssistants.put(handlerType, assistant);
            }
        }
        if (assistant != null) {
            List<Object> context = Arrays.asList(exceptionContext);
            page = assistant.handleRequestException(exception, context);
            exceptionContext = context.toArray();
        }
        if (page == null) {
            return;
        }
        exceptionContext = new Object[]{};
        try {
            Link link;
            if (page instanceof Class) {
                page = this.componentClassResolver.resolvePageClassNameToPageName(((Class)page).getName());
            }
            Link link2 = link = page instanceof Link ? (Link)page : this.linkSource.createPageRenderLink(page.toString(), false, exceptionContext);
            if (this.request.isXHR()) {
                OutputStream os = this.response.getOutputStream("application/json;charset=UTF-8");
                os.write(("{\"redirectURL\":\"" + link.toAbsoluteURI() + "\"}").getBytes());
                os.close();
            } else {
                this.response.sendRedirect(link);
            }
        }
        catch (Exception e) {
            this.defaultRequestExceptionHandler.handleRequestException(exception);
        }
    }
}

