/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.seedentity.services;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tapestry5.hibernate.HibernateSessionManager;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.metadata.ClassMetadata;
import org.slf4j.Logger;
import org.tynamo.seedentity.SeedEntityIdentifier;
import org.tynamo.seedentity.services.SeedEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerLoad
public class SeedEntityImpl
implements SeedEntity {
    public SeedEntityImpl(Logger logger, HibernateSessionSource sessionSource, HibernateSessionManager sessionManager, List<Object> entities) {
        Session session = sessionManager.getSession();
        SessionFactory sessionFactory = sessionSource.getSessionFactory();
        for (Object object : entities) {
            Object entity;
            String uniquelyIdentifyingProperty = null;
            if (object instanceof SeedEntityIdentifier) {
                uniquelyIdentifyingProperty = ((SeedEntityIdentifier)object).getUniquelyIdentifyingProperty();
                entity = ((SeedEntityIdentifier)object).getEntity();
            } else {
                entity = object;
            }
            if (entity.getClass().getAnnotation(Entity.class) == null) {
                logger.warn("Contributed object '" + entity + "' is not an entity, cannot be used a seed");
                continue;
            }
            PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(entity.getClass());
            HashSet<String> nonUniqueProperties = new HashSet<String>(descriptors.length);
            for (PropertyDescriptor descriptor : descriptors) {
                nonUniqueProperties.add(descriptor.getName());
            }
            if (uniquelyIdentifyingProperty == null) {
                Set<String> uniqueProperties = this.findPossiblePropertiesWithUniqueColumnAnnotation(entity, descriptors);
                for (String uniqueProperty : uniqueProperties) {
                    nonUniqueProperties.remove(uniqueProperty);
                }
            } else {
                nonUniqueProperties.remove(uniquelyIdentifyingProperty);
            }
            Example example = Example.create((Object)entity);
            for (String nonUniqueProperty : nonUniqueProperties) {
                example.excludeProperty(nonUniqueProperty);
            }
            List results = session.createCriteria(entity.getClass()).add((Criterion)example).list();
            if (results.size() > 0) {
                logger.info("At least one existing entity with same unique properties as '" + entity + "' of type '" + entity.getClass().getSimpleName() + "' already exists, skipping seeding this entity");
                ClassMetadata metadata = sessionFactory.getClassMetadata(entity.getClass());
                metadata.setIdentifier(entity, metadata.getIdentifier(results.get(0), EntityMode.POJO), EntityMode.POJO);
                continue;
            }
            session.save(entity);
        }
        sessionManager.commit();
    }

    private Set<String> findPossiblePropertiesWithUniqueColumnAnnotation(Object entity, PropertyDescriptor[] descriptors) {
        Field[] fields;
        Method[] methods;
        Table annotation;
        HashSet<String> uniqueProperties = new HashSet<String>();
        if (entity.getClass().isAnnotationPresent(Table.class) && (annotation = entity.getClass().getAnnotation(Table.class)).uniqueConstraints() != null) {
            for (UniqueConstraint uniqueConstraint : annotation.uniqueConstraints()) {
                for (String uniqueColumn : uniqueConstraint.columnNames()) {
                    uniqueProperties.add(uniqueColumn);
                }
            }
        }
        Class<?> aClass = entity.getClass();
        for (Method method : methods = aClass.getDeclaredMethods()) {
            PropertyDescriptor descriptor;
            Column annotation2;
            if (!method.isAnnotationPresent(Column.class) || !(annotation2 = method.getAnnotation(Column.class)).unique() || (descriptor = SeedEntityImpl.findPropertyForMethod(method, descriptors)) == null) continue;
            uniqueProperties.add(descriptor.getName());
        }
        for (Field currentField : fields = aClass.getDeclaredFields()) {
            Column annotation3;
            currentField.setAccessible(true);
            if (!currentField.isAnnotationPresent(Column.class) || !(annotation3 = currentField.getAnnotation(Column.class)).unique()) continue;
            uniqueProperties.add(currentField.getName());
        }
        return uniqueProperties;
    }

    public static PropertyDescriptor findPropertyForMethod(Method method, PropertyDescriptor[] descriptors) {
        for (PropertyDescriptor pd : descriptors) {
            if (!method.equals(pd.getReadMethod()) && !method.equals(pd.getWriteMethod())) continue;
            return pd;
        }
        return null;
    }
}

