/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.seedentity.hibernate.services;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.tapestry5.hibernate.HibernateSessionSource;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.annotations.NaturalId;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.metadata.ClassMetadata;
import org.slf4j.Logger;
import org.tynamo.seedentity.SeedEntityIdentifier;
import org.tynamo.seedentity.SeedEntityUpdater;
import org.tynamo.seedentity.hibernate.services.SeedEntity;

@EagerLoad
public class SeedEntityImpl
implements SeedEntity {
    private Map<Class, SeedEntityIdentifier> typeIdentifiers = new HashMap<Class, SeedEntityIdentifier>();
    private SessionFactory sessionFactory;
    private Logger logger;
    private List<Object> newlyAddedEntities = new ArrayList<Object>();

    public SeedEntityImpl(Logger logger, HibernateSessionSource sessionSource, List<Object> entities) {
        this.logger = logger;
        this.sessionFactory = sessionSource.getSessionFactory();
        if (entities != null && entities.size() > 0) {
            Session session = sessionSource.create();
            this.seed(session, entities);
            session.close();
        }
    }

    void seed(Session session, List<Object> entities) {
        Transaction tx = session.beginTransaction();
        for (Object object : entities) {
            Object entity;
            if (object instanceof SeedEntityUpdater) {
                SeedEntityUpdater entityUpdater = (SeedEntityUpdater)object;
                if (!this.newlyAddedEntities.contains(entityUpdater.getOriginalEntity()) && !entityUpdater.isForceUpdate()) {
                    this.logger.info("Entity '" + entityUpdater.getUpdatedEntity() + "' of type " + entityUpdater.getUpdatedEntity().getClass().getSimpleName() + " was not newly added, ignoring update");
                    continue;
                }
                if (!entityUpdater.getOriginalEntity().getClass().equals(entityUpdater.getUpdatedEntity().getClass())) {
                    throw new ClassCastException("The type of original entity doesn't match with the updated entity");
                }
                ClassMetadata metadata = this.sessionFactory.getClassMetadata(entityUpdater.getOriginalEntity().getClass());
                Serializable identifier = metadata.getIdentifier(entityUpdater.getOriginalEntity(), EntityMode.POJO);
                if (identifier == null) {
                    throw new IllegalStateException("Cannot make an update to the entity '" + entityUpdater.getUpdatedEntity() + " of type " + entityUpdater.getUpdatedEntity().getClass().getSimpleName() + " because the identifier of the original entity is not set");
                }
                metadata.setIdentifier(entityUpdater.getUpdatedEntity(), identifier, EntityMode.POJO);
                tx.commit();
                session.evict(entityUpdater.getOriginalEntity());
                tx = session.beginTransaction();
                session.update(entityUpdater.getUpdatedEntity());
                continue;
            }
            String uniquelyIdentifyingProperty = null;
            if (object instanceof SeedEntityIdentifier) {
                SeedEntityIdentifier entityIdentifier = (SeedEntityIdentifier)object;
                if (entityIdentifier.getEntity() instanceof Class) {
                    this.typeIdentifiers.put((Class)entityIdentifier.getEntity(), entityIdentifier);
                    continue;
                }
                uniquelyIdentifyingProperty = entityIdentifier.getUniquelyIdentifyingProperty();
                entity = entityIdentifier.getEntity();
            } else {
                entity = object;
            }
            if (entity.getClass().getAnnotation(Entity.class) == null) {
                this.logger.warn("Contributed object '" + entity + "' is not an entity, cannot be used a seed");
                continue;
            }
            if (this.typeIdentifiers.containsKey(object.getClass())) {
                uniquelyIdentifyingProperty = this.typeIdentifiers.get(object.getClass()).getUniquelyIdentifyingProperty();
            }
            PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors(entity.getClass());
            HashSet<String> nonUniqueProperties = new HashSet<String>(descriptors.length);
            for (PropertyDescriptor descriptor : descriptors) {
                nonUniqueProperties.add(descriptor.getName());
            }
            if (uniquelyIdentifyingProperty == null) {
                Set<String> uniqueProperties = this.findPossiblePropertiesWithUniqueColumnAnnotation(entity, descriptors);
                for (String uniqueProperty : uniqueProperties) {
                    nonUniqueProperties.remove(uniqueProperty);
                }
            } else {
                nonUniqueProperties.remove(uniquelyIdentifyingProperty);
            }
            Example example = Example.create((Object)entity);
            for (String nonUniqueProperty : nonUniqueProperties) {
                example.excludeProperty(nonUniqueProperty);
            }
            List results = session.createCriteria(entity.getClass()).add((Criterion)example).list();
            if (results.size() > 0) {
                this.logger.info("At least one existing entity with same unique properties as '" + entity + "' of type '" + entity.getClass().getSimpleName() + "' already exists, skipping seeding this entity");
                Object existingObject = results.get(0);
                session.evict(existingObject);
                ClassMetadata metadata = this.sessionFactory.getClassMetadata(entity.getClass());
                metadata.setIdentifier(entity, metadata.getIdentifier(existingObject, EntityMode.POJO), EntityMode.POJO);
                continue;
            }
            session.save(entity);
            this.newlyAddedEntities.add(entity);
        }
        tx.commit();
        this.newlyAddedEntities.clear();
    }

    private Set<String> findPossiblePropertiesWithUniqueColumnAnnotation(Object entity, PropertyDescriptor[] descriptors) {
        Field[] fields;
        Method[] methods;
        Table annotation;
        HashSet<String> uniqueProperties = new HashSet<String>();
        if (entity.getClass().isAnnotationPresent(Table.class) && (annotation = entity.getClass().getAnnotation(Table.class)).uniqueConstraints() != null) {
            for (UniqueConstraint uniqueConstraint : annotation.uniqueConstraints()) {
                for (String uniqueColumn : uniqueConstraint.columnNames()) {
                    uniqueProperties.add(uniqueColumn);
                }
            }
        }
        Class<?> aClass = entity.getClass();
        for (Method method : methods = aClass.getDeclaredMethods()) {
            PropertyDescriptor descriptor;
            Column columnAnnotation;
            if (!method.isAnnotationPresent(NaturalId.class) && !method.isAnnotationPresent(Column.class) || (columnAnnotation = method.getAnnotation(Column.class)) != null && !columnAnnotation.unique() || (descriptor = SeedEntityImpl.findPropertyForMethod(method, descriptors)) == null) continue;
            uniqueProperties.add(descriptor.getName());
        }
        for (Field currentField : fields = aClass.getDeclaredFields()) {
            Column columnAnnotation;
            currentField.setAccessible(true);
            if (!currentField.isAnnotationPresent(NaturalId.class) && !currentField.isAnnotationPresent(Column.class) || (columnAnnotation = currentField.getAnnotation(Column.class)) != null && !columnAnnotation.unique()) continue;
            uniqueProperties.add(currentField.getName());
        }
        return uniqueProperties;
    }

    public static PropertyDescriptor findPropertyForMethod(Method method, PropertyDescriptor[] descriptors) {
        for (PropertyDescriptor pd : descriptors) {
            if (!method.equals(pd.getReadMethod()) && !method.equals(pd.getWriteMethod())) continue;
            return pd;
        }
        return null;
    }
}

