/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jdo.internal;

import java.lang.reflect.Method;
import org.apache.tapestry5.ioc.Invocation;
import org.apache.tapestry5.ioc.MethodAdvice;
import org.apache.tapestry5.ioc.MethodAdviceReceiver;
import org.tynamo.jdo.JDOTransactionAdvisor;
import org.tynamo.jdo.JDOTransactionManager;
import org.tynamo.jdo.annotations.CommitAfter;

public class JDOTransactionAdvisorImpl
implements JDOTransactionAdvisor {
    private final JDOTransactionManager manager;
    private final MethodAdvice advice = new MethodAdvice(){

        public void advise(Invocation invocation) {
            try {
                invocation.proceed();
            }
            catch (RuntimeException ex) {
                JDOTransactionAdvisorImpl.this.manager.abort();
                throw ex;
            }
            JDOTransactionAdvisorImpl.this.manager.commit();
        }
    };

    public JDOTransactionAdvisorImpl(JDOTransactionManager manager) {
        this.manager = manager;
    }

    public void addTransactionCommitAdvice(MethodAdviceReceiver receiver) {
        for (Method m : receiver.getInterface().getMethods()) {
            if (m.getAnnotation(CommitAfter.class) == null) continue;
            receiver.adviseMethod(m, this.advice);
        }
    }
}

