/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jdo.internal;

import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.services.ClassTransformation;
import org.apache.tapestry5.services.ComponentClassTransformWorker;
import org.apache.tapestry5.services.ComponentMethodAdvice;
import org.apache.tapestry5.services.ComponentMethodInvocation;
import org.apache.tapestry5.services.TransformMethod;
import org.tynamo.jdo.JDOTransactionManager;
import org.tynamo.jdo.annotations.CommitAfter;

public class CommitAfterWorker
implements ComponentClassTransformWorker {
    private final JDOTransactionManager manager;
    private final ComponentMethodAdvice advice = new ComponentMethodAdvice(){

        public void advise(ComponentMethodInvocation invocation) {
            try {
                invocation.proceed();
                CommitAfterWorker.this.manager.commit();
            }
            catch (RuntimeException ex) {
                CommitAfterWorker.this.manager.abort();
                throw ex;
            }
        }
    };

    public CommitAfterWorker(JDOTransactionManager manager) {
        this.manager = manager;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        for (TransformMethod sig : transformation.matchMethodsWithAnnotation(CommitAfter.class)) {
            sig.addAdvice(this.advice);
        }
    }
}

