/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jdo.internal;

import java.io.Serializable;
import javax.jdo.PersistenceManager;
import org.apache.tapestry5.internal.services.AbstractSessionPersistentFieldStrategy;
import org.apache.tapestry5.services.Request;
import org.tynamo.jdo.internal.JDOMessages;
import org.tynamo.jdo.internal.PersistedEntity;

public class EntityPersistentFieldStrategy
extends AbstractSessionPersistentFieldStrategy {
    private final PersistenceManager persistenceManager;

    public EntityPersistentFieldStrategy(PersistenceManager pm, Request request) {
        super("entity:", request);
        this.persistenceManager = pm;
    }

    protected Object convertApplicationValueToPersisted(Object persistentObject) {
        Class<?> entityName = persistentObject.getClass();
        Serializable id = (Serializable)this.persistenceManager.getObjectId(persistentObject);
        if (id == null) {
            throw new IllegalArgumentException(JDOMessages.entityNotAttached(persistentObject));
        }
        return new PersistedEntity(entityName, id);
    }

    protected Object convertPersistedToApplicationValue(Object persistedValue) {
        PersistedEntity persisted = (PersistedEntity)persistedValue;
        return persisted.restore(this.persistenceManager);
    }
}

