/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jdo.internal;

import java.io.Serializable;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.metadata.MemberMetadata;
import javax.jdo.metadata.TypeMetadata;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.PropertyAdapter;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDOEntityValueEncoder<E>
implements ValueEncoder<E> {
    private final PersistenceManager pm;
    private final TypeCoercer typeCoercer;
    private final Logger logger;
    private final Class persistenceCapableClass;
    private final Class objectIdClass;
    private final String idPropertyName;
    private final PropertyAdapter propertyAdapter;

    public JDOEntityValueEncoder(Class<E> pcClass, PersistenceManager pm, PropertyAccess propertyAccess, TypeCoercer typeCoercer, Logger logger) {
        this.pm = pm;
        this.typeCoercer = typeCoercer;
        this.logger = logger;
        this.persistenceCapableClass = pcClass;
        this.objectIdClass = pm.getObjectIdClass(pcClass);
        this.idPropertyName = this.findIdPropertyName(pm, pcClass);
        this.propertyAdapter = propertyAccess.getAdapter(pcClass).getPropertyAdapter(this.idPropertyName);
    }

    public String toClient(E value) {
        if (value == null) {
            return null;
        }
        Object id = this.propertyAdapter.get(value);
        if (id == null) {
            throw new IllegalStateException(String.format("PersistenceCapable %s has an id of null; this probably means that it has not been persisted yet.", value));
        }
        return (String)this.typeCoercer.coerce(id, String.class);
    }

    public E toValue(String clientValue) {
        if (InternalUtils.isBlank((String)clientValue)) {
            return null;
        }
        Object id = null;
        try {
            id = this.typeCoercer.coerce((Object)clientValue, this.propertyAdapter.getType());
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Exception converting '%s' to instance of %s (id type for entity %s): %s", clientValue, this.objectIdClass.getName(), this.persistenceCapableClass.getName(), InternalUtils.toMessage((Throwable)ex)), ex);
        }
        Serializable ser = (Serializable)id;
        Object result = null;
        try {
            result = this.pm.getObjectById(this.persistenceCapableClass, (Object)ser);
        }
        catch (JDOObjectNotFoundException e) {
            this.logger.error(String.format("Unable to convert client value '%s' into an entity instance.", clientValue));
        }
        return (E)result;
    }

    private String findIdPropertyName(PersistenceManager pm, Class<E> pcClass) {
        String idPropName = null;
        TypeMetadata metadata = pm.getPersistenceManagerFactory().getMetadata(pcClass.getName());
        for (MemberMetadata elementMetadata : metadata.getMembers()) {
            if (!elementMetadata.getPrimaryKey()) continue;
            idPropName = elementMetadata.getName();
        }
        if (idPropName != null) {
            return idPropName;
        }
        throw new RuntimeException("No primary key property found for class : " + pcClass);
    }
}

