/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jdo.internal;

import java.io.Serializable;
import javax.jdo.PersistenceManager;
import org.apache.tapestry5.annotations.ImmutableSessionPersistedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tynamo.jdo.internal.JDOMessages;

@ImmutableSessionPersistedObject
public class PersistedEntity
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(PersistedEntity.class);
    private final Class persistentClass;
    private final Serializable id;

    public PersistedEntity(Class pcClass, Serializable id) {
        this.persistentClass = pcClass;
        this.id = id;
    }

    public Object restore(PersistenceManager pm) {
        Object result = null;
        try {
            result = pm.getObjectById((Object)this.id);
        }
        catch (Exception ex) {
            logger.info(JDOMessages.sessionPersistedEntityLoadFailure(this.persistentClass, this.id, ex));
        }
        return result;
    }

    public String toString() {
        return String.format("<PersistenceCapable: %s(%s)>", this.persistentClass, this.id);
    }
}

