/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jpa.internal;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.slf4j.Logger;
import org.tynamo.jpa.JPAEntityManagerSource;
import org.tynamo.jpa.internal.JPACoreMessages;

public class JPAEntityManagerSourceImpl
implements JPAEntityManagerSource,
RegistryShutdownListener {
    private final EntityManagerFactory entityManagerFactory;

    public JPAEntityManagerSourceImpl(Logger logger, String persistenceUnit) {
        long startTime = System.currentTimeMillis();
        long configurationComplete = System.currentTimeMillis();
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)persistenceUnit);
        long factoryCreated = System.currentTimeMillis();
        logger.info(JPACoreMessages.startupTiming(configurationComplete - startTime, factoryCreated - startTime));
    }

    public EntityManager create() {
        return this.entityManagerFactory.createEntityManager();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void registryDidShutdown() {
        this.entityManagerFactory.close();
    }
}

