/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.seedentity.jpa.services;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.apache.tapestry5.ioc.annotations.EagerLoad;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.jpa.EntityManagerManager;
import org.slf4j.Logger;
import org.tynamo.seedentity.SeedEntityIdentifier;
import org.tynamo.seedentity.SeedEntityUpdater;
import org.tynamo.seedentity.jpa.services.SeedEntity;

@EagerLoad
public class SeedEntityImpl
implements SeedEntity {
    private Map<Class, SeedEntityIdentifier> typeIdentifiers = new HashMap<Class, SeedEntityIdentifier>();
    private Logger logger;
    private List<Object> newlyAddedEntities = new ArrayList<Object>();
    private PropertyAccess propertyAccess;

    public SeedEntityImpl(Logger logger, PropertyAccess propertyAccess, EntityManagerManager entityManagerManager, @Inject @Symbol(value="seedentity.persistenceunit") String persistenceUnitName, List<Object> entities) {
        this.logger = logger;
        this.propertyAccess = propertyAccess;
        EntityManager entityManager = null;
        if (persistenceUnitName.isEmpty()) {
            if (entityManagerManager.getEntityManagers().size() != 1) {
                throw new IllegalArgumentException("You have to specify the persistenceunit for seedentity if multiple persistence units are configured in the system. Contribute a value for SeedEntity.PERSISTENCEUNIT");
            }
            entityManager = (EntityManager)entityManagerManager.getEntityManagers().values().iterator().next();
        } else {
            entityManager = entityManagerManager.getEntityManager(persistenceUnitName);
            if (entityManager == null) {
                throw new IllegalArgumentException("Persistence unit '" + persistenceUnitName + "' is configured for seedentity, but it was not found. Check that the contributed name matches with persistenceunit configuration");
            }
        }
        this.seed(entityManager, entities);
    }

    void seed(EntityManager entityManager, List<Object> entities) {
        Metamodel metamodel = entityManager.getMetamodel();
        EntityTransaction tx = entityManager.getTransaction();
        tx.begin();
        for (Object object : entities) {
            Object entity;
            EntityType entityType;
            if (object instanceof SeedEntityUpdater) {
                SeedEntityUpdater entityUpdater = (SeedEntityUpdater)object;
                if (!this.newlyAddedEntities.contains(entityUpdater.getOriginalEntity()) && !entityUpdater.isForceUpdate()) {
                    this.logger.info("Entity '" + entityUpdater.getUpdatedEntity() + "' of type " + entityUpdater.getUpdatedEntity().getClass().getSimpleName() + " was not newly added, ignoring update");
                    continue;
                }
                if (!entityUpdater.getOriginalEntity().getClass().equals(entityUpdater.getUpdatedEntity().getClass())) {
                    throw new ClassCastException("The type of original entity doesn't match with the updated entity");
                }
                entityType = metamodel.entity(entityUpdater.getOriginalEntity().getClass());
                Type idType = entityType.getIdType();
                SingularAttribute idAttr = entityType.getId(idType.getJavaType());
                Object identifier = this.propertyAccess.get(entityUpdater.getOriginalEntity(), idAttr.getName());
                if (identifier == null) {
                    throw new IllegalStateException("Cannot make an update to the entity '" + entityUpdater.getUpdatedEntity() + " of type " + entityUpdater.getUpdatedEntity().getClass().getSimpleName() + " because the identifier of the original entity is not set");
                }
                this.propertyAccess.set(entityUpdater.getUpdatedEntity(), idAttr.getName(), identifier);
                entityManager.merge(entityUpdater.getUpdatedEntity());
                continue;
            }
            String uniquelyIdentifyingProperty = null;
            if (object instanceof SeedEntityIdentifier) {
                SeedEntityIdentifier entityIdentifier = (SeedEntityIdentifier)object;
                if (entityIdentifier.getEntity() instanceof Class) {
                    this.typeIdentifiers.put((Class)entityIdentifier.getEntity(), entityIdentifier);
                    continue;
                }
                uniquelyIdentifyingProperty = entityIdentifier.getUniquelyIdentifyingProperty();
                entity = entityIdentifier.getEntity();
            } else {
                entity = object;
            }
            if (entity.getClass().getAnnotation(Entity.class) == null) {
                this.logger.warn("Contributed object '" + entity + "' is not an entity, cannot be used a seed");
                continue;
            }
            if (this.typeIdentifiers.containsKey(object.getClass())) {
                uniquelyIdentifyingProperty = this.typeIdentifiers.get(object.getClass()).getUniquelyIdentifyingProperty();
            }
            entityType = metamodel.entity(entity.getClass());
            Set singularAttributes = entityType.getSingularAttributes();
            CriteriaBuilder cb = entityManager.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(entity.getClass());
            Root root = query.from(entityType);
            SingularAttribute idAttr = null;
            HashSet<Predicate> predicates = new HashSet<Predicate>();
            for (SingularAttribute a : singularAttributes) {
                if (a.isId()) {
                    idAttr = a;
                    continue;
                }
                if (!this.isUnique(entity.getClass(), a)) continue;
                predicates.add(cb.equal((Expression)root.get(a.getName()), this.propertyAccess.get(entity, a.getName())));
            }
            query.where((Expression)cb.and(predicates.toArray(new Predicate[0])));
            List results = entityManager.createQuery(query).getResultList();
            if (results.size() > 0) {
                this.logger.info("At least one existing entity with the same unique properties as '" + entity + "' of type '" + entity.getClass().getSimpleName() + "' already exists, skipping seeding this entity");
                Object existingObject = results.get(0);
                entityManager.detach(existingObject);
                this.propertyAccess.set(entity, idAttr.getName(), this.propertyAccess.get(existingObject, idAttr.getName()));
                continue;
            }
            entityManager.persist(entity);
            this.newlyAddedEntities.add(entity);
        }
        tx.commit();
        this.newlyAddedEntities.clear();
    }

    private boolean isUnique(Class entityType, SingularAttribute attribute) {
        Table annotation;
        if (entityType.isAnnotationPresent(Table.class) && (annotation = entityType.getAnnotation(Table.class)).uniqueConstraints() != null) {
            for (UniqueConstraint uniqueConstraint : annotation.uniqueConstraints()) {
                for (String uniqueColumn : uniqueConstraint.columnNames()) {
                    if (!attribute.getName().equals(uniqueColumn)) continue;
                    return true;
                }
            }
        }
        return (annotation = (Column)this.getAnnotation(attribute.getJavaMember(), Column.class)) != null && annotation.unique();
    }

    private Annotation getAnnotation(Member member, Class annotationType) {
        return member instanceof Field ? ((Field)member).getAnnotation(annotationType) : (member instanceof Method ? ((Method)member).getAnnotation(annotationType) : null);
    }
}

