/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jpa.internal;

import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.services.ClassTransformation;
import org.apache.tapestry5.services.ComponentClassTransformWorker;
import org.apache.tapestry5.services.ComponentMethodAdvice;
import org.apache.tapestry5.services.ComponentMethodInvocation;
import org.apache.tapestry5.services.TransformMethodSignature;
import org.tynamo.jpa.JPATransactionManager;
import org.tynamo.jpa.annotations.CommitAfter;

public class CommitAfterWorker
implements ComponentClassTransformWorker {
    private final JPATransactionManager manager;
    private final ComponentMethodAdvice advice = new ComponentMethodAdvice(){

        public void advise(ComponentMethodInvocation invocation) {
            try {
                invocation.proceed();
                CommitAfterWorker.this.manager.commit();
            }
            catch (RuntimeException ex) {
                CommitAfterWorker.this.manager.abort();
                throw ex;
            }
        }
    };

    public CommitAfterWorker(JPATransactionManager manager) {
        this.manager = manager;
    }

    public void transform(ClassTransformation transformation, MutableComponentModel model) {
        for (TransformMethodSignature sig : transformation.findMethodsWithAnnotation(CommitAfter.class)) {
            transformation.advise(sig, this.advice);
        }
    }
}

