/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jpa.internal;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.tapestry5.internal.services.AbstractSessionPersistentFieldStrategy;
import org.apache.tapestry5.services.Request;
import org.tynamo.jpa.internal.JPAMessages;
import org.tynamo.jpa.internal.PersistedEntity;

public class EntityPersistentFieldStrategy
extends AbstractSessionPersistentFieldStrategy {
    private final EntityManager entityManager;

    public EntityPersistentFieldStrategy(EntityManager entityManager, Request request) {
        super("entity:", request);
        this.entityManager = entityManager;
    }

    protected Object convertApplicationValueToPersisted(Object newValue) {
        try {
            Class<?> entityName = newValue.getClass();
            Serializable id = (Serializable)this.entityManager.getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(newValue);
            return new PersistedEntity(entityName, id);
        }
        catch (PersistenceException ex) {
            throw new IllegalArgumentException(JPAMessages.entityNotAttached(newValue), ex);
        }
    }

    protected Object convertPersistedToApplicationValue(Object persistedValue) {
        PersistedEntity persisted = (PersistedEntity)persistedValue;
        return persisted.restore(this.entityManager);
    }
}

