/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jpa.internal;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.metamodel.EntityType;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JPAEntityValueEncoder<E>
implements ValueEncoder<E> {
    private final EntityType<E> entityType;
    private final EntityManager em;
    private final TypeCoercer typeCoercer;
    private final Logger logger;
    private final Class idClass;
    private final PersistenceUnitUtil puu;

    public JPAEntityValueEncoder(Class<E> entityClass, EntityManager em, PropertyAccess propertyAccess, TypeCoercer typeCoercer, Logger logger) {
        this.em = em;
        this.entityType = em.getMetamodel().entity(entityClass);
        this.typeCoercer = typeCoercer;
        this.logger = logger;
        this.puu = em.getEntityManagerFactory().getPersistenceUnitUtil();
        this.idClass = this.entityType.getIdType().getJavaType();
    }

    public String toClient(E value) {
        if (value == null) {
            return null;
        }
        Object id = this.puu.getIdentifier(value);
        if (id == null) {
            throw new IllegalStateException(String.format("Entity %s has an id of null; this probably means that it has not been persisted yet.", value));
        }
        return (String)this.typeCoercer.coerce(id, String.class);
    }

    public E toValue(String clientValue) {
        if (InternalUtils.isBlank((String)clientValue)) {
            return null;
        }
        Object id = this.typeCoercer.coerce((Object)clientValue, this.idClass);
        Serializable ser = (Serializable)Defense.cast((Object)id, Serializable.class, (String)"id");
        Object result = this.em.find(this.entityType.getJavaType(), (Object)ser);
        if (result == null) {
            this.logger.error(String.format("Unable to convert client value '%s' into an entity instance.", clientValue));
        }
        return (E)result;
    }
}

