/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jpa.internal;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.SortConstraint;
import org.apache.tapestry5.ioc.internal.util.Defense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAGridDataSource<E>
implements GridDataSource {
    protected final EntityManager entityManager;
    private final Class<E> entityType;
    private int startIndex;
    private List preparedResults;

    public JPAGridDataSource(EntityManager em, Class<E> entityType) {
        Defense.notNull((Object)em, (String)"entityManager");
        Defense.notNull(entityType, (String)"entityType");
        this.entityManager = em;
        this.entityType = entityType;
    }

    public int getAvailableRows() {
        CriteriaQuery resultQuery;
        Root all;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        Expression<Boolean> query = this.additionalConstraints(cb, all = (resultQuery = cb.createQuery(Long.class)).from(this.entityType));
        if (query != null) {
            resultQuery.where(query).select((Selection)cb.count((Expression)all));
        } else {
            resultQuery.select((Selection)cb.count((Expression)all));
        }
        TypedQuery finalQ = this.entityManager.createQuery(resultQuery);
        Long result = (Long)finalQ.getSingleResult();
        return result.intValue();
    }

    public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
        Defense.notNull(sortConstraints, (String)"sortConstraints");
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery resultQuery = cb.createQuery(this.entityType);
        Root all = resultQuery.from(this.entityType);
        Expression<Boolean> query = this.additionalConstraints(cb, all);
        if (query != null) {
            resultQuery.where(query).select((Selection)all);
        } else {
            resultQuery.select((Selection)all);
        }
        for (SortConstraint constraint : sortConstraints) {
            String propertyName = constraint.getPropertyModel().getPropertyName();
            switch (constraint.getColumnSort()) {
                case ASCENDING: {
                    resultQuery.orderBy(new Order[]{cb.asc((Expression)all.get(propertyName))});
                    break;
                }
                case DESCENDING: {
                    resultQuery.orderBy(new Order[]{cb.desc((Expression)all.get(propertyName))});
                    break;
                }
            }
        }
        TypedQuery finalQ = this.entityManager.createQuery(resultQuery);
        finalQ.setFirstResult(startIndex);
        finalQ.setMaxResults(endIndex - startIndex + 1);
        this.startIndex = startIndex;
        this.preparedResults = finalQ.getResultList();
    }

    protected Expression<Boolean> additionalConstraints(CriteriaBuilder cb, Root<E> root) {
        return null;
    }

    public Object getRowValue(int index) {
        return this.preparedResults.get(index - this.startIndex);
    }

    public Class getRowType() {
        return this.entityType;
    }
}

