/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.jpa.internal;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.apache.tapestry5.annotations.ImmutableSessionPersistedObject;
import org.tynamo.jpa.internal.JPAMessages;

@ImmutableSessionPersistedObject
public class PersistedEntity
implements Serializable {
    private final Class entityName;
    private final Serializable id;

    public PersistedEntity(Class entityName, Serializable id) {
        this.entityName = entityName;
        this.id = id;
    }

    Object restore(EntityManager entityManager) {
        try {
            return entityManager.find(this.entityName, (Object)this.id);
        }
        catch (Exception ex) {
            throw new RuntimeException(JPAMessages.sessionPersistedEntityLoadFailure(this.entityName, this.id, ex));
        }
    }

    public String toString() {
        return String.format("<PersistedEntity: %s(%s)>", this.entityName, this.id);
    }
}

