/*
 * Decompiled with CFR 0.152.
 */
package org.tynamo.descriptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tynamo.descriptor.TynamoPropertyDescriptor;
import org.tynamo.descriptor.TynamoPropertyDescriptorImpl;
import org.tynamo.exception.TynamoRuntimeException;

public class CollectionDescriptor
extends TynamoPropertyDescriptorImpl {
    protected static final Log LOG = LogFactory.getLog(CollectionDescriptor.class);
    private Class elementType;
    private boolean childRelationship = false;
    private String inverseProperty = null;
    private boolean oneToMany = false;
    private String addExpression = null;
    private String removeExpression = null;
    private String swapExpression = null;
    private boolean allowRemove = true;

    public CollectionDescriptor(Class beanType, TynamoPropertyDescriptor descriptor) {
        super(beanType, descriptor);
    }

    public CollectionDescriptor(Class beanType, CollectionDescriptor collectionDescriptor) {
        super(beanType, collectionDescriptor.getBeanType());
        this.copyFrom(collectionDescriptor);
    }

    public CollectionDescriptor(Class beanType, String name, Class type) {
        super(beanType, type);
        this.setName(name);
    }

    public boolean isCollection() {
        return true;
    }

    public Class getElementType() {
        return this.elementType;
    }

    public void setElementType(Class elementType) {
        this.elementType = elementType;
    }

    public String getInverseProperty() {
        return this.inverseProperty;
    }

    public void setInverseProperty(String inverseProperty) {
        this.inverseProperty = inverseProperty;
    }

    public boolean isOneToMany() {
        return this.oneToMany;
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public boolean isChildRelationship() {
        return this.childRelationship;
    }

    public void setChildRelationship(boolean childRelationship) {
        this.childRelationship = childRelationship;
        if (this.childRelationship) {
            this.setSearchable(false);
        }
    }

    public String getAddExpression() {
        if (this.addExpression == null) {
            this.addExpression = this.findAddExpression();
        }
        return this.addExpression;
    }

    public void setAddExpression(String addExpression) {
        this.addExpression = addExpression;
    }

    public String getRemoveExpression() {
        if (this.removeExpression == null) {
            this.removeExpression = this.findRemoveExpression();
        }
        return this.removeExpression;
    }

    public void setRemoveExpression(String removeExpression) {
        this.removeExpression = removeExpression;
    }

    public String getSwapExpression() {
        return this.swapExpression;
    }

    public void setSwapExpression(String swapExpression) {
        this.swapExpression = swapExpression;
    }

    public boolean isAllowRemove() {
        return this.allowRemove;
    }

    public void setAllowRemove(boolean allowRemove) {
        this.allowRemove = allowRemove;
    }

    public Object clone() {
        return new CollectionDescriptor(this.getBeanType(), this);
    }

    private String findAddExpression() {
        String method = "add";
        if (this.isChildRelationship() && List.class.isAssignableFrom(this.getType())) {
            return this.findExpression("add", this.getName() + ".contains(#member) ? " + this.getName() + ".size() : " + this.getName() + "." + "add");
        }
        return this.findExpression("add");
    }

    private String findRemoveExpression() {
        return this.findExpression("remove");
    }

    private String findExpression(String method, String defaultValue) {
        Method addMethod = null;
        try {
            addMethod = this.getBeanType().getMethod(method + this.getElementType().getSimpleName(), this.getElementType());
        }
        catch (NoSuchMethodException ex) {
            return defaultValue;
        }
        catch (Exception e) {
            throw new TynamoRuntimeException(e);
        }
        return addMethod.getName();
    }

    String findExpression(String method) {
        return this.findExpression(method, this.getName() + "." + method);
    }

    private void copyFrom(CollectionDescriptor collectionDescriptor) {
        LOG.debug((Object)"Cloning CollectionDescriptor");
        try {
            BeanUtils.copyProperties((Object)this, (Object)collectionDescriptor);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)e.getMessage());
        }
    }
}

